/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateAckListener;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.RestoreInProgress;
import org.elasticsearch.cluster.SimpleBatchedAckListenerTaskExecutor;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexGraveyard;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.routing.allocation.allocator.AllocationActionListener;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.cluster.service.MasterServiceTaskQueue;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.Index;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.snapshots.RestoreService;
import org.elasticsearch.snapshots.SnapshotInProgressException;
import org.elasticsearch.snapshots.SnapshotsServiceUtils;

public class MetadataDeleteIndexService {
    private static final Logger logger = LogManager.getLogger(MetadataDeleteIndexService.class);
    final ClusterStateTaskExecutor<DeleteIndicesClusterStateUpdateTask> executor;
    private final MasterServiceTaskQueue<DeleteIndicesClusterStateUpdateTask> taskQueue;

    @Inject
    public MetadataDeleteIndexService(final Settings settings, ClusterService clusterService, final AllocationService allocationService) {
        this.executor = new SimpleBatchedAckListenerTaskExecutor<DeleteIndicesClusterStateUpdateTask>(this){

            @Override
            public Tuple<ClusterState, ClusterStateAckListener> executeTask(DeleteIndicesClusterStateUpdateTask task, ClusterState clusterState) {
                return Tuple.tuple((Object)MetadataDeleteIndexService.deleteIndices(clusterState, task.indices, settings), (Object)task);
            }

            @Override
            public ClusterState afterBatchExecution(ClusterState clusterState, boolean clusterStateChanged) {
                if (clusterStateChanged) {
                    return allocationService.reroute(clusterState, "deleted indices", AllocationActionListener.rerouteCompletionIsNotRequired());
                }
                return clusterState;
            }
        };
        this.taskQueue = clusterService.createTaskQueue("delete-index", Priority.URGENT, this.executor);
    }

    public void deleteIndices(TimeValue masterNodeTimeout, TimeValue ackTimeout, Set<Index> indices, ActionListener<AcknowledgedResponse> listener) {
        if (indices == null || indices.isEmpty()) {
            throw new IllegalArgumentException("Indices are required");
        }
        this.taskQueue.submitTask("delete-index " + String.valueOf(indices), new DeleteIndicesClusterStateUpdateTask(indices, ackTimeout, listener), masterNodeTimeout);
    }

    public static ClusterState deleteIndices(ClusterState clusterState, Set<Index> indices, Settings settings) {
        HashMap<ProjectId, Set> byProject = new HashMap<ProjectId, Set>();
        for (Index index : indices) {
            ProjectMetadata project = clusterState.metadata().projectFor(index);
            byProject.computeIfAbsent(project.id(), ignore -> new HashSet()).add(index);
        }
        for (Map.Entry entry : byProject.entrySet()) {
            clusterState = MetadataDeleteIndexService.deleteIndices(clusterState.projectState((ProjectId)entry.getKey()), (Set<Index>)((Set)entry.getValue()), settings);
        }
        return clusterState;
    }

    public static ClusterState deleteIndices(ProjectState projectState, Set<Index> indices, Settings settings) {
        ProjectMetadata project = projectState.metadata();
        HashSet<Index> indicesToDelete = new HashSet<Index>();
        HashMap<Index, DataStream> dataStreamIndices = new HashMap<Index, DataStream>();
        for (Index index : indices) {
            IndexMetadata im = project.getIndexSafe(index);
            DataStream parent = ((IndexAbstraction)project.getIndicesLookup().get(im.getIndex().getName())).getParentDataStream();
            if (parent != null) {
                boolean isFailureStoreWriteIndex = im.getIndex().equals(parent.getWriteFailureIndex());
                if (isFailureStoreWriteIndex || im.getIndex().equals(parent.getWriteIndex())) {
                    throw new IllegalArgumentException("index [" + index.getName() + "] is the " + (isFailureStoreWriteIndex ? "failure store " : "") + "write index for data stream [" + parent.getName() + "] and cannot be deleted");
                }
                dataStreamIndices.put(index, parent);
            }
            indicesToDelete.add(im.getIndex());
        }
        Set<Index> snapshottingIndices = SnapshotsServiceUtils.snapshottingIndices(projectState, indicesToDelete);
        if (!snapshottingIndices.isEmpty()) {
            throw new SnapshotInProgressException("Cannot delete indices that are being snapshotted: " + String.valueOf(snapshottingIndices) + ". Try again after snapshot finishes or cancel the currently running snapshot.");
        }
        RoutingTable.Builder routingTableBuilder = RoutingTable.builder(projectState.routingTable());
        ProjectMetadata.Builder projectBuilder = ProjectMetadata.builder(project);
        ClusterBlocks.Builder clusterBlocksBuilder = ClusterBlocks.builder().blocks(projectState.cluster().blocks());
        IndexGraveyard.Builder graveyardBuilder = IndexGraveyard.builder(projectBuilder.indexGraveyard());
        int previousGraveyardSize = graveyardBuilder.tombstones().size();
        for (Index index : indices) {
            String indexName = index.getName();
            logger.info("{} deleting index", (Object)index);
            routingTableBuilder.remove(indexName);
            clusterBlocksBuilder.removeIndexBlocks(projectState.projectId(), indexName);
            projectBuilder.remove(indexName);
            if (!dataStreamIndices.containsKey(index)) continue;
            DataStream parent = projectBuilder.dataStream(((DataStream)dataStreamIndices.get(index)).getName());
            if (parent.isFailureStoreIndex(index.getName())) {
                projectBuilder.put(parent.removeFailureStoreIndex(index));
                continue;
            }
            projectBuilder.put(parent.removeBackingIndex(index));
        }
        IndexGraveyard currentGraveyard = graveyardBuilder.addTombstones(indices).build(settings);
        projectBuilder.indexGraveyard(currentGraveyard);
        logger.trace("{} tombstones purged from the cluster state. Previous tombstone size: {}. Current tombstone size: {}.", (Object)graveyardBuilder.getNumPurged(), (Object)previousGraveyardSize, (Object)currentGraveyard.getTombstones().size());
        Map<String, ClusterState.Custom> customs = projectState.cluster().getCustoms();
        RestoreInProgress restoreInProgress = RestoreInProgress.get(projectState.cluster());
        RestoreInProgress updatedRestoreInProgress = RestoreService.updateRestoreStateWithDeletedIndices(restoreInProgress, indices);
        if (updatedRestoreInProgress != restoreInProgress) {
            ImmutableOpenMap.Builder<String, ClusterState.Custom> builder = ImmutableOpenMap.builder(customs);
            builder.put("restore", updatedRestoreInProgress);
            customs = builder.build();
        }
        return ClusterState.builder(projectState.cluster()).putRoutingTable(project.id(), routingTableBuilder.build()).putProjectMetadata(projectBuilder.build()).blocks(clusterBlocksBuilder.build()).customs(customs).build();
    }

    static class DeleteIndicesClusterStateUpdateTask
    implements ClusterStateTaskListener,
    ClusterStateAckListener {
        private final Set<Index> indices;
        private final TimeValue ackTimeout;
        private final ActionListener<AcknowledgedResponse> listener;

        DeleteIndicesClusterStateUpdateTask(Set<Index> indices, TimeValue ackTimeout, ActionListener<AcknowledgedResponse> listener) {
            this.indices = Objects.requireNonNull(indices);
            this.ackTimeout = Objects.requireNonNull(ackTimeout);
            this.listener = Objects.requireNonNull(listener);
        }

        @Override
        public boolean mustAck(DiscoveryNode discoveryNode) {
            return true;
        }

        @Override
        public void onAllNodesAcked() {
            this.listener.onResponse(AcknowledgedResponse.TRUE);
        }

        @Override
        public void onAckFailure(Exception e) {
            this.listener.onResponse(AcknowledgedResponse.FALSE);
        }

        @Override
        public void onAckTimeout() {
            this.listener.onResponse(AcknowledgedResponse.FALSE);
        }

        @Override
        public TimeValue ackTimeout() {
            return this.ackTimeout;
        }

        @Override
        public void onFailure(Exception e) {
            this.listener.onFailure(e);
        }
    }
}

