/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.gcs;

import com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.google.api.gax.retrying.TimedAttemptSettings;
import com.google.cloud.storage.StorageRetryStrategy;
import java.util.concurrent.CancellationException;

public class ShouldRetryDecorator<T>
implements StorageRetryStrategy {
    private final ResultRetryAlgorithm<T> idempotentRetryAlgorithm;
    private final ResultRetryAlgorithm<T> nonIdempotentRetryAlgorithm;

    public static StorageRetryStrategy decorate(StorageRetryStrategy delegate, Decorator<?> shouldRetryDecorator) {
        return new ShouldRetryDecorator(delegate, shouldRetryDecorator);
    }

    private ShouldRetryDecorator(StorageRetryStrategy delegate, Decorator<T> shouldRetryDecorator) {
        this.idempotentRetryAlgorithm = new DelegatingResultRetryAlgorithm<T>(delegate.getIdempotentHandler(), shouldRetryDecorator);
        this.nonIdempotentRetryAlgorithm = new DelegatingResultRetryAlgorithm<T>(delegate.getNonidempotentHandler(), shouldRetryDecorator);
    }

    public ResultRetryAlgorithm<?> getIdempotentHandler() {
        return this.idempotentRetryAlgorithm;
    }

    public ResultRetryAlgorithm<?> getNonidempotentHandler() {
        return this.nonIdempotentRetryAlgorithm;
    }

    public static interface Decorator<R> {
        public boolean shouldRetry(Throwable var1, R var2, ResultRetryAlgorithm<R> var3);
    }

    private record DelegatingResultRetryAlgorithm<R>(ResultRetryAlgorithm<R> delegate, Decorator<R> shouldRetryDecorator) implements ResultRetryAlgorithm<R>
    {
        public TimedAttemptSettings createNextAttempt(Throwable prevThrowable, R prevResponse, TimedAttemptSettings prevSettings) {
            return this.delegate.createNextAttempt(prevThrowable, prevResponse, prevSettings);
        }

        public boolean shouldRetry(Throwable prevThrowable, R prevResponse) throws CancellationException {
            return this.shouldRetryDecorator.shouldRetry(prevThrowable, prevResponse, this.delegate);
        }
    }
}

