/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datastreams.lifecycle.action;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Set;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeReadProjectAction;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.datastreams.lifecycle.DataStreamLifecycleService;
import org.elasticsearch.datastreams.lifecycle.action.GetDataStreamLifecycleStatsAction;
import org.elasticsearch.index.Index;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportGetDataStreamLifecycleStatsAction
extends TransportMasterNodeReadProjectAction<GetDataStreamLifecycleStatsAction.Request, GetDataStreamLifecycleStatsAction.Response> {
    private final DataStreamLifecycleService lifecycleService;

    @Inject
    public TransportGetDataStreamLifecycleStatsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, DataStreamLifecycleService lifecycleService, ProjectResolver projectResolver) {
        super("cluster:monitor/data_stream/lifecycle/stats", transportService, clusterService, threadPool, actionFilters, GetDataStreamLifecycleStatsAction.Request::new, projectResolver, GetDataStreamLifecycleStatsAction.Response::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.lifecycleService = lifecycleService;
    }

    protected void masterOperation(Task task, GetDataStreamLifecycleStatsAction.Request request, ProjectState state, ActionListener<GetDataStreamLifecycleStatsAction.Response> listener) throws Exception {
        listener.onResponse((Object)this.collectStats(state.metadata()));
    }

    GetDataStreamLifecycleStatsAction.Response collectStats(ProjectMetadata project) {
        Set<String> indicesInErrorStore = this.lifecycleService.getErrorStore().getAllIndices(project.id());
        ArrayList<GetDataStreamLifecycleStatsAction.Response.DataStreamStats> dataStreamStats = new ArrayList<GetDataStreamLifecycleStatsAction.Response.DataStreamStats>();
        for (DataStream dataStream : project.dataStreams().values()) {
            if (dataStream.getDataLifecycle() == null || !dataStream.getDataLifecycle().enabled()) continue;
            int total = 0;
            int inError = 0;
            for (Index index : dataStream.getIndices()) {
                if (!dataStream.isIndexManagedByDataStreamLifecycle(index, arg_0 -> ((ProjectMetadata)project).index(arg_0))) continue;
                ++total;
                if (!indicesInErrorStore.contains(index.getName())) continue;
                ++inError;
            }
            dataStreamStats.add(new GetDataStreamLifecycleStatsAction.Response.DataStreamStats(dataStream.getName(), total, inError));
        }
        return new GetDataStreamLifecycleStatsAction.Response(this.lifecycleService.getLastRunDuration(), this.lifecycleService.getTimeBetweenStarts(), dataStreamStats.isEmpty() ? dataStreamStats : dataStreamStats.stream().sorted(Comparator.comparing(GetDataStreamLifecycleStatsAction.Response.DataStreamStats::dataStreamName)).toList());
    }

    protected ClusterBlockException checkBlock(GetDataStreamLifecycleStatsAction.Request request, ProjectState state) {
        return state.blocks().globalBlockedException(state.projectId(), ClusterBlockLevel.METADATA_READ);
    }
}

