/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datastreams.action;

import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.datastreams.MigrateToDataStreamAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeProjectAction;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.elasticsearch.cluster.metadata.MetadataMigrateToDataStreamService;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportMigrateToDataStreamAction
extends AcknowledgedTransportMasterNodeProjectAction<MigrateToDataStreamAction.Request> {
    private final MetadataMigrateToDataStreamService metadataMigrateToDataStreamService;

    @Inject
    public TransportMigrateToDataStreamAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, ProjectResolver projectResolver, IndicesService indicesService, MetadataCreateIndexService metadataCreateIndexService) {
        super("indices:admin/data_stream/migrate", transportService, clusterService, threadPool, actionFilters, MigrateToDataStreamAction.Request::new, projectResolver, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.metadataMigrateToDataStreamService = new MetadataMigrateToDataStreamService(threadPool, clusterService, indicesService, metadataCreateIndexService);
    }

    protected void masterOperation(Task task, MigrateToDataStreamAction.Request request, ProjectState state, ActionListener<AcknowledgedResponse> listener) {
        MetadataMigrateToDataStreamService.MigrateToDataStreamClusterStateUpdateRequest updateRequest = new MetadataMigrateToDataStreamService.MigrateToDataStreamClusterStateUpdateRequest(request.getAliasName(), request.masterNodeTimeout(), request.ackTimeout());
        this.metadataMigrateToDataStreamService.migrateToDataStream(state.projectId(), updateRequest, listener);
    }

    protected ClusterBlockException checkBlock(MigrateToDataStreamAction.Request request, ProjectState state) {
        return state.blocks().globalBlockedException(state.projectId(), ClusterBlockLevel.METADATA_WRITE);
    }
}

