/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.exponentialhistogram;

import java.util.Iterator;
import java.util.List;
import java.util.OptionalLong;
import org.apache.lucene.util.Accountable;
import org.elasticsearch.exponentialhistogram.BucketIterator;
import org.elasticsearch.exponentialhistogram.CopyableBucketIterator;
import org.elasticsearch.exponentialhistogram.EmptyExponentialHistogram;
import org.elasticsearch.exponentialhistogram.ExponentialHistogramBuilder;
import org.elasticsearch.exponentialhistogram.ExponentialHistogramCircuitBreaker;
import org.elasticsearch.exponentialhistogram.ExponentialHistogramGenerator;
import org.elasticsearch.exponentialhistogram.ExponentialHistogramMerger;
import org.elasticsearch.exponentialhistogram.ReleasableExponentialHistogram;
import org.elasticsearch.exponentialhistogram.ZeroBucket;

public interface ExponentialHistogram
extends Accountable {
    public static final int MAX_SCALE = 38;
    public static final int MIN_SCALE = -11;
    public static final int MAX_INDEX_BITS = 62;
    public static final long MAX_INDEX = 0x3FFFFFFFFFFFFFFFL;
    public static final long MIN_INDEX = -4611686018427387903L;

    public int scale();

    public ZeroBucket zeroBucket();

    public Buckets positiveBuckets();

    public Buckets negativeBuckets();

    public double sum();

    public long valueCount();

    public double min();

    public double max();

    public static boolean equals(ExponentialHistogram a, ExponentialHistogram b) {
        if (a == b) {
            return true;
        }
        if (a == null) {
            return false;
        }
        if (b == null) {
            return false;
        }
        return a.scale() == b.scale() && a.sum() == b.sum() && ExponentialHistogram.equalsIncludingNaN(a.min(), b.min()) && ExponentialHistogram.equalsIncludingNaN(a.max(), b.max()) && a.zeroBucket().equals(b.zeroBucket()) && ExponentialHistogram.bucketIteratorsEqual(a.negativeBuckets().iterator(), b.negativeBuckets().iterator()) && ExponentialHistogram.bucketIteratorsEqual(a.positiveBuckets().iterator(), b.positiveBuckets().iterator());
    }

    private static boolean equalsIncludingNaN(double a, double b) {
        return a == b || Double.isNaN(a) && Double.isNaN(b);
    }

    private static boolean bucketIteratorsEqual(BucketIterator a, BucketIterator b) {
        if (a.scale() != b.scale()) {
            return false;
        }
        while (a.hasNext() && b.hasNext()) {
            if (a.peekIndex() != b.peekIndex() || a.peekCount() != b.peekCount()) {
                return false;
            }
            a.advance();
            b.advance();
        }
        return a.hasNext() == b.hasNext();
    }

    public static int hashCode(ExponentialHistogram histogram) {
        int hash = histogram.scale();
        hash = 31 * hash + Double.hashCode(histogram.sum());
        hash = 31 * hash + Long.hashCode(histogram.valueCount());
        hash = 31 * hash + Double.hashCode(histogram.min());
        hash = 31 * hash + Double.hashCode(histogram.max());
        hash = 31 * hash + histogram.zeroBucket().hashCode();
        return hash;
    }

    public static ExponentialHistogram empty() {
        return EmptyExponentialHistogram.INSTANCE;
    }

    public static ExponentialHistogramBuilder builder(int scale, ExponentialHistogramCircuitBreaker breaker) {
        return new ExponentialHistogramBuilder(scale, breaker);
    }

    public static ExponentialHistogramBuilder builder(ExponentialHistogram toCopy, ExponentialHistogramCircuitBreaker breaker) {
        return new ExponentialHistogramBuilder(toCopy, breaker);
    }

    public static ReleasableExponentialHistogram create(int maxBucketCount, ExponentialHistogramCircuitBreaker breaker, double ... values) {
        try (ExponentialHistogramGenerator generator = ExponentialHistogramGenerator.create(maxBucketCount, breaker);){
            for (double val : values) {
                generator.add(val);
            }
            ReleasableExponentialHistogram releasableExponentialHistogram = generator.getAndClear();
            return releasableExponentialHistogram;
        }
    }

    public static ReleasableExponentialHistogram merge(int maxBucketCount, ExponentialHistogramCircuitBreaker breaker, Iterator<ExponentialHistogram> histograms) {
        try (ExponentialHistogramMerger merger = ExponentialHistogramMerger.create(maxBucketCount, breaker);){
            while (histograms.hasNext()) {
                merger.add(histograms.next());
            }
            ReleasableExponentialHistogram releasableExponentialHistogram = merger.getAndClear();
            return releasableExponentialHistogram;
        }
    }

    public static ReleasableExponentialHistogram merge(int maxBucketCount, ExponentialHistogramCircuitBreaker breaker, ExponentialHistogram ... histograms) {
        return ExponentialHistogram.merge(maxBucketCount, breaker, List.of(histograms).iterator());
    }

    public static interface Buckets {
        public CopyableBucketIterator iterator();

        public OptionalLong maxBucketIndex();

        public long valueCount();
    }
}

