/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.azure;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.SecureSetting;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;

final class AzureStorageSettings {
    public static final int DEFAULT_MAX_RETRIES = 3;
    private static final String AZURE_CLIENT_PREFIX_KEY = "azure.client.";
    public static final Setting.AffixSetting<SecureString> ACCOUNT_SETTING = Setting.affixKeySetting((String)"azure.client.", (String)"account", key -> SecureSetting.secureString((String)key, null, (Setting.Property[])new Setting.Property[0]), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<SecureString> KEY_SETTING = Setting.affixKeySetting((String)"azure.client.", (String)"key", key -> SecureSetting.secureString((String)key, null, (Setting.Property[])new Setting.Property[0]), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<SecureString> SAS_TOKEN_SETTING = Setting.affixKeySetting((String)"azure.client.", (String)"sas_token", key -> SecureSetting.secureString((String)key, null, (Setting.Property[])new Setting.Property[0]), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<Integer> MAX_RETRIES_SETTING = Setting.affixKeySetting((String)"azure.client.", (String)"max_retries", key -> Setting.intSetting((String)key, (int)3, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[]{() -> ACCOUNT_SETTING});
    public static final Setting.AffixSetting<String> ENDPOINT_SUFFIX_SETTING = Setting.affixKeySetting((String)"azure.client.", (String)"endpoint_suffix", key -> Setting.simpleString((String)key, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[]{() -> ACCOUNT_SETTING});
    public static final Setting.AffixSetting<String> ENDPOINT_SETTING = Setting.affixKeySetting((String)"azure.client.", (String)"endpoint", key -> Setting.simpleString((String)key, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[]{() -> ACCOUNT_SETTING});
    public static final Setting.AffixSetting<String> SECONDARY_ENDPOINT_SETTING = Setting.affixKeySetting((String)"azure.client.", (String)"secondary_endpoint", key -> Setting.simpleString((String)key, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[]{() -> ACCOUNT_SETTING});
    public static final Setting.AffixSetting<TimeValue> TIMEOUT_SETTING = Setting.affixKeySetting((String)"azure.client.", (String)"timeout", key -> Setting.timeSetting((String)key, (TimeValue)TimeValue.timeValueMinutes((long)-1L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[]{() -> ACCOUNT_SETTING});
    public static final Setting.AffixSetting<Proxy.Type> PROXY_TYPE_SETTING = Setting.affixKeySetting((String)"azure.client.", (String)"proxy.type", key -> new Setting(key, "direct", s -> Proxy.Type.valueOf(s.toUpperCase(Locale.ROOT)), new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[]{() -> ACCOUNT_SETTING});
    public static final Setting.AffixSetting<String> PROXY_HOST_SETTING = Setting.affixKeySetting((String)"azure.client.", (String)"proxy.host", key -> Setting.simpleString((String)key, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[]{() -> ACCOUNT_SETTING, () -> PROXY_TYPE_SETTING});
    public static final Setting<Integer> PROXY_PORT_SETTING = Setting.affixKeySetting((String)"azure.client.", (String)"proxy.port", key -> Setting.intSetting((String)key, (int)0, (int)0, (int)65535, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[]{() -> ACCOUNT_SETTING, () -> PROXY_TYPE_SETTING, () -> PROXY_HOST_SETTING});
    private final String account;
    private final String connectString;
    private final String endpointSuffix;
    private final TimeValue timeout;
    private final int maxRetries;
    private final Proxy proxy;
    private final boolean hasCredentials;
    private final Set<String> credentialsUsageFeatures;
    private static final String BLOB_ENDPOINT_NAME = "BlobEndpoint";
    private static final String BLOB_SECONDARY_ENDPOINT_NAME = "BlobSecondaryEndpoint";
    private static final String DEFAULT_DNS = "core.windows.net";

    private AzureStorageSettings(String account, String key, String sasToken, String endpointSuffix, TimeValue timeout, int maxRetries, Proxy.Type proxyType, String proxyHost, Integer proxyPort, String endpoint, String secondaryEndpoint) {
        this.account = account;
        this.connectString = AzureStorageSettings.buildConnectString(account, key, sasToken, endpointSuffix, endpoint, secondaryEndpoint);
        this.hasCredentials = Strings.hasText((String)key) || Strings.hasText((String)sasToken);
        this.endpointSuffix = endpointSuffix;
        this.timeout = timeout;
        this.maxRetries = maxRetries;
        Set<String> set = Strings.hasText((String)key) ? Set.of("uses_key_credentials") : (Strings.hasText((String)sasToken) ? Set.of("uses_sas_token") : (this.credentialsUsageFeatures = System.getenv("AZURE_FEDERATED_TOKEN_FILE") == null ? Set.of("uses_default_credentials", "uses_managed_identity") : Set.of("uses_default_credentials", "uses_workload_identity")));
        if (proxyType.equals((Object)Proxy.Type.DIRECT) && (proxyPort != 0 || Strings.hasText((String)proxyHost))) {
            throw new SettingsException("Azure Proxy port or host have been set but proxy type is not defined.");
        }
        if (!proxyType.equals((Object)Proxy.Type.DIRECT) && (proxyPort == 0 || Strings.isEmpty((CharSequence)proxyHost))) {
            throw new SettingsException("Azure Proxy type has been set but proxy host or port is not defined.");
        }
        if (proxyType.equals((Object)Proxy.Type.DIRECT)) {
            this.proxy = null;
        } else {
            try {
                this.proxy = new Proxy(proxyType, new InetSocketAddress(InetAddress.getByName(proxyHost), (int)proxyPort));
            }
            catch (UnknownHostException e) {
                throw new SettingsException("Azure proxy host is unknown.", (Throwable)e);
            }
        }
    }

    public String getEndpointSuffix() {
        return this.endpointSuffix;
    }

    public TimeValue getTimeout() {
        return this.timeout;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public String getConnectString() {
        return this.connectString;
    }

    private static String buildConnectString(String account, @Nullable String key, @Nullable String sasToken, String endpointSuffix, @Nullable String endpoint, @Nullable String secondaryEndpoint) {
        boolean hasSasToken = Strings.hasText((String)sasToken);
        boolean hasKey = Strings.hasText((String)key);
        if (hasSasToken && hasKey) {
            throw new SettingsException("Both a secret as well as a shared access token were set for account [" + account + "]");
        }
        StringBuilder connectionStringBuilder = new StringBuilder();
        connectionStringBuilder.append("DefaultEndpointsProtocol=https").append(";AccountName=").append(account);
        if (hasKey) {
            connectionStringBuilder.append(";AccountKey=").append(key);
        } else if (hasSasToken) {
            connectionStringBuilder.append(";SharedAccessSignature=").append(sasToken);
        } else {
            connectionStringBuilder.append(";AccountKey=none");
        }
        boolean hasEndpointSuffix = Strings.hasText((String)endpointSuffix);
        boolean hasEndpoint = Strings.hasText((String)endpoint);
        boolean hasSecondaryEndpoint = Strings.hasText((String)secondaryEndpoint);
        if (hasEndpointSuffix && hasEndpoint) {
            throw new SettingsException("Both an endpoint suffix as well as a primary endpoint were set for account [" + account + "]");
        }
        if (hasEndpointSuffix && hasSecondaryEndpoint) {
            throw new SettingsException("Both an endpoint suffix as well as a secondary endpoint were set for account [" + account + "]");
        }
        if (!hasEndpoint && hasSecondaryEndpoint) {
            throw new SettingsException("A primary endpoint is required when setting a secondary endpoint for account [" + account + "]");
        }
        if (hasEndpointSuffix) {
            connectionStringBuilder.append(";EndpointSuffix=").append(endpointSuffix);
        }
        if (hasEndpoint) {
            connectionStringBuilder.append(";BlobEndpoint=").append(endpoint);
        }
        if (hasSecondaryEndpoint) {
            connectionStringBuilder.append(";BlobSecondaryEndpoint=").append(secondaryEndpoint);
        }
        return connectionStringBuilder.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AzureStorageSettings{");
        sb.append("account='").append(this.account).append('\'');
        sb.append(", timeout=").append(this.timeout);
        sb.append(", endpointSuffix='").append(this.endpointSuffix).append('\'');
        sb.append(", maxRetries=").append(this.maxRetries);
        sb.append(", proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }

    public static Map<String, AzureStorageSettings> load(Settings settings) {
        HashMap<String, AzureStorageSettings> storageSettings = new HashMap<String, AzureStorageSettings>();
        for (String clientName : ACCOUNT_SETTING.getNamespaces(settings)) {
            storageSettings.put(clientName, AzureStorageSettings.getClientSettings(settings, clientName));
        }
        if (!storageSettings.containsKey("default") && !storageSettings.isEmpty()) {
            AzureStorageSettings defaultSettings = (AzureStorageSettings)storageSettings.values().iterator().next();
            storageSettings.put("default", defaultSettings);
        }
        assert (storageSettings.containsKey("default") || storageSettings.isEmpty()) : "always have 'default' if any";
        return Collections.unmodifiableMap(storageSettings);
    }

    /*
     * Exception decompiling
     */
    private static AzureStorageSettings getClientSettings(Settings settings, String clientName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static <T> T getConfigValue(Settings settings, String clientName, Setting.AffixSetting<T> clientSetting) {
        Setting concreteSetting = clientSetting.getConcreteSettingForNamespace(clientName);
        return (T)concreteSetting.get(settings);
    }

    private static <T> T getValue(Settings settings, String groupName, Setting<T> setting) {
        Setting.AffixKey k = (Setting.AffixKey)setting.getRawKey();
        String fullKey = k.toConcreteKey(groupName);
        return (T)setting.getConcreteSetting(fullKey).get(settings);
    }

    public boolean hasCredentials() {
        return this.hasCredentials;
    }

    StorageEndpoint getStorageEndpoint() {
        String primaryURI = this.getProperty(BLOB_ENDPOINT_NAME);
        String secondaryURI = this.getProperty(BLOB_SECONDARY_ENDPOINT_NAME);
        if (primaryURI != null) {
            return new StorageEndpoint(primaryURI, secondaryURI);
        }
        return new StorageEndpoint(this.deriveURIFromSettings(true), this.deriveURIFromSettings(false));
    }

    private String getProperty(String propertyName) {
        String[] settings = this.getConnectString().split(";");
        for (int i = 0; i < settings.length; ++i) {
            String setting = settings[i].trim();
            if (setting.length() <= 0) continue;
            int idx = setting.indexOf(61);
            if (idx == -1 || idx == 0 || idx == settings[i].length() - 1) {
                new IllegalArgumentException("Invalid connection string: " + this.getConnectString());
            }
            if (!propertyName.equals(setting.substring(0, idx))) continue;
            return setting.substring(idx + 1);
        }
        return null;
    }

    private String deriveURIFromSettings(boolean isPrimary) {
        String uriString = "https://" + this.account + (isPrimary ? "" : "-secondary") + ".blob." + (Strings.isNullOrEmpty((String)this.endpointSuffix) ? DEFAULT_DNS : this.endpointSuffix);
        try {
            return new URI(uriString).toString();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Set<String> credentialsUsageFeatures() {
        return this.credentialsUsageFeatures;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AzureStorageSettings that = (AzureStorageSettings)o;
        return this.maxRetries == that.maxRetries && this.hasCredentials == that.hasCredentials && Objects.equals(this.account, that.account) && Objects.equals(this.connectString, that.connectString) && Objects.equals(this.endpointSuffix, that.endpointSuffix) && Objects.equals(this.timeout, that.timeout) && Objects.equals(this.proxy, that.proxy) && Objects.equals(this.credentialsUsageFeatures, that.credentialsUsageFeatures);
    }

    public int hashCode() {
        return Objects.hash(this.account, this.connectString, this.endpointSuffix, this.timeout, this.maxRetries, this.proxy, this.hasCredentials, this.credentialsUsageFeatures);
    }

    record StorageEndpoint(String primaryURI, @Nullable String secondaryURI) {
    }
}

