/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesTo;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesToLifecycle;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.FunctionType;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Sum;
import org.elasticsearch.xpack.esql.expression.function.aggregate.SummationMode;
import org.elasticsearch.xpack.esql.expression.function.aggregate.TimeSeriesAggregateFunction;

public class SumOverTime
extends TimeSeriesAggregateFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "SumOverTime", SumOverTime::new);

    @FunctionInfo(returnType={"double", "long"}, description="Calculates the sum over time value of a field.", type=FunctionType.TIME_SERIES_AGGREGATE, appliesTo={@FunctionAppliesTo(lifeCycle=FunctionAppliesToLifecycle.PREVIEW, version="9.2.0")}, preview=true, examples={@Example(file="k8s-timeseries", tag="sum_over_time")})
    public SumOverTime(Source source, @Param(name="field", type={"aggregate_metric_double", "double", "integer", "long"}) Expression field) {
        this(source, field, (Expression)Literal.TRUE);
    }

    public SumOverTime(Source source, Expression field, Expression filter) {
        super(source, field, filter, Collections.emptyList());
    }

    private SumOverTime(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return SumOverTime.ENTRY.name;
    }

    @Override
    public SumOverTime withFilter(Expression filter) {
        return new SumOverTime(this.source(), this.field(), filter);
    }

    protected NodeInfo<SumOverTime> info() {
        return NodeInfo.create((Node)this, SumOverTime::new, (Object)this.field(), (Object)this.filter());
    }

    public SumOverTime replaceChildren(List<Expression> newChildren) {
        return new SumOverTime(this.source(), newChildren.get(0), newChildren.get(1));
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return this.perTimeSeriesAggregation().resolveType();
    }

    public DataType dataType() {
        return this.perTimeSeriesAggregation().dataType();
    }

    @Override
    public Sum perTimeSeriesAggregation() {
        return new Sum(this.source(), this.field(), this.filter(), (Expression)SummationMode.LOSSY_LITERAL);
    }
}

