/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockruntime.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CachePointType {
    DEFAULT("default"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CachePointType> VALUE_MAP;
    private final String value;

    private CachePointType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CachePointType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CachePointType> knownValues() {
        EnumSet<CachePointType> knownValues = EnumSet.allOf(CachePointType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CachePointType.class, CachePointType::toString);
    }
}

