/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.voyageai.embeddings;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.client.utils.URIBuilder;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.ChunkingSettings;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.ModelSecrets;
import org.elasticsearch.inference.SecretSettings;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.request.RequestUtils;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.settings.DefaultSecretSettings;
import org.elasticsearch.xpack.inference.services.voyageai.VoyageAIModel;
import org.elasticsearch.xpack.inference.services.voyageai.action.VoyageAIActionVisitor;
import org.elasticsearch.xpack.inference.services.voyageai.embeddings.VoyageAIEmbeddingsServiceSettings;
import org.elasticsearch.xpack.inference.services.voyageai.embeddings.VoyageAIEmbeddingsTaskSettings;

public class VoyageAIEmbeddingsModel
extends VoyageAIModel {
    public static VoyageAIEmbeddingsModel of(VoyageAIEmbeddingsModel model, Map<String, Object> taskSettings) {
        VoyageAIEmbeddingsTaskSettings requestTaskSettings = VoyageAIEmbeddingsTaskSettings.fromMap(taskSettings);
        return new VoyageAIEmbeddingsModel(model, VoyageAIEmbeddingsTaskSettings.of(model.getTaskSettings(), requestTaskSettings));
    }

    public VoyageAIEmbeddingsModel(String inferenceId, String service, Map<String, Object> serviceSettings, Map<String, Object> taskSettings, ChunkingSettings chunkingSettings, @Nullable Map<String, Object> secrets, ConfigurationParseContext context) {
        this(inferenceId, service, VoyageAIEmbeddingsServiceSettings.fromMap(serviceSettings, context), VoyageAIEmbeddingsTaskSettings.fromMap(taskSettings), chunkingSettings, DefaultSecretSettings.fromMap(secrets), RequestUtils.buildUri("voyageai", (CheckedSupplier<URI, URISyntaxException>)((CheckedSupplier)VoyageAIEmbeddingsModel::buildRequestUri)));
    }

    public static URI buildRequestUri() throws URISyntaxException {
        return new URIBuilder().setScheme("https").setHost("api.voyageai.com").setPathSegments(new String[]{"v1", "embeddings"}).build();
    }

    VoyageAIEmbeddingsModel(String inferenceId, String service, String url, VoyageAIEmbeddingsServiceSettings serviceSettings, VoyageAIEmbeddingsTaskSettings taskSettings, ChunkingSettings chunkingSettings, @Nullable DefaultSecretSettings secretSettings) {
        this(inferenceId, service, serviceSettings, taskSettings, chunkingSettings, secretSettings, ServiceUtils.createUri(url));
    }

    private VoyageAIEmbeddingsModel(String inferenceId, String service, VoyageAIEmbeddingsServiceSettings serviceSettings, VoyageAIEmbeddingsTaskSettings taskSettings, ChunkingSettings chunkingSettings, @Nullable DefaultSecretSettings secretSettings, URI uri) {
        super(new ModelConfigurations(inferenceId, TaskType.TEXT_EMBEDDING, service, (ServiceSettings)serviceSettings, (TaskSettings)taskSettings, chunkingSettings), new ModelSecrets((SecretSettings)secretSettings), secretSettings, serviceSettings.getCommonSettings(), uri);
    }

    private VoyageAIEmbeddingsModel(VoyageAIEmbeddingsModel model, VoyageAIEmbeddingsTaskSettings taskSettings) {
        super((VoyageAIModel)model, (TaskSettings)taskSettings);
    }

    public VoyageAIEmbeddingsModel(VoyageAIEmbeddingsModel model, VoyageAIEmbeddingsServiceSettings serviceSettings) {
        super((VoyageAIModel)model, (ServiceSettings)serviceSettings);
    }

    public VoyageAIEmbeddingsServiceSettings getServiceSettings() {
        return (VoyageAIEmbeddingsServiceSettings)super.getServiceSettings();
    }

    public VoyageAIEmbeddingsTaskSettings getTaskSettings() {
        return (VoyageAIEmbeddingsTaskSettings)super.getTaskSettings();
    }

    public DefaultSecretSettings getSecretSettings() {
        return (DefaultSecretSettings)super.getSecretSettings();
    }

    @Override
    public ExecutableAction accept(VoyageAIActionVisitor visitor, Map<String, Object> taskSettings) {
        return visitor.create(this, taskSettings);
    }
}

