/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.elastic.request;

import org.apache.http.client.methods.HttpRequestBase;
import org.elasticsearch.Version;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.xpack.inference.external.request.HttpRequest;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.services.elastic.request.ElasticInferenceServiceRequestMetadata;

public abstract class ElasticInferenceServiceRequest
implements Request {
    private final ElasticInferenceServiceRequestMetadata metadata;

    public ElasticInferenceServiceRequest(ElasticInferenceServiceRequestMetadata metadata) {
        this.metadata = metadata;
    }

    public ElasticInferenceServiceRequestMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public final HttpRequest createHttpRequest() {
        HttpRequestBase request = this.createHttpRequestBase();
        String productOrigin = this.metadata.productOrigin();
        String productUseCase = this.metadata.productUseCase();
        String esVersion = this.metadata.esVersion();
        if (!Strings.isNullOrEmpty((String)productOrigin)) {
            request.setHeader("X-elastic-product-origin", productOrigin);
        }
        if (!Strings.isNullOrEmpty((String)productUseCase)) {
            request.addHeader("X-elastic-product-use-case", productUseCase);
        }
        if (!Strings.isNullOrEmpty((String)esVersion)) {
            request.addHeader("X-elastic-es-version", esVersion);
        }
        return new HttpRequest(request, this.getInferenceEntityId());
    }

    protected abstract HttpRequestBase createHttpRequestBase();

    public static ElasticInferenceServiceRequestMetadata extractRequestMetadataFromThreadContext(ThreadContext context) {
        return new ElasticInferenceServiceRequestMetadata(context.getHeader("X-elastic-product-origin"), context.getHeader("X-elastic-product-use-case"), Version.CURRENT.toString());
    }
}

