/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.ai21.action;

import java.util.Objects;
import org.elasticsearch.core.Strings;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.action.SingleInputSenderExecutableAction;
import org.elasticsearch.xpack.inference.external.http.retry.ErrorResponse;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseHandler;
import org.elasticsearch.xpack.inference.external.http.sender.ChatCompletionInput;
import org.elasticsearch.xpack.inference.external.http.sender.GenericRequestManager;
import org.elasticsearch.xpack.inference.external.http.sender.Sender;
import org.elasticsearch.xpack.inference.external.http.sender.UnifiedChatInput;
import org.elasticsearch.xpack.inference.services.ServiceComponents;
import org.elasticsearch.xpack.inference.services.ai21.action.Ai21ActionVisitor;
import org.elasticsearch.xpack.inference.services.ai21.completion.Ai21ChatCompletionModel;
import org.elasticsearch.xpack.inference.services.ai21.request.Ai21ChatCompletionRequest;
import org.elasticsearch.xpack.inference.services.openai.OpenAiChatCompletionResponseHandler;
import org.elasticsearch.xpack.inference.services.openai.response.OpenAiChatCompletionResponseEntity;

public class Ai21ActionCreator
implements Ai21ActionVisitor {
    public static final String COMPLETION_ERROR_PREFIX = "AI21 completions";
    public static final String USER_ROLE = "user";
    public static final ResponseHandler COMPLETION_HANDLER = new OpenAiChatCompletionResponseHandler("ai21 completions", OpenAiChatCompletionResponseEntity::fromResponse, ErrorResponse::fromResponse);
    private final Sender sender;
    private final ServiceComponents serviceComponents;

    public Ai21ActionCreator(Sender sender, ServiceComponents serviceComponents) {
        this.sender = Objects.requireNonNull(sender);
        this.serviceComponents = Objects.requireNonNull(serviceComponents);
    }

    @Override
    public ExecutableAction create(Ai21ChatCompletionModel chatCompletionModel) {
        GenericRequestManager<ChatCompletionInput> manager = new GenericRequestManager<ChatCompletionInput>(this.serviceComponents.threadPool(), chatCompletionModel, COMPLETION_HANDLER, inputs -> new Ai21ChatCompletionRequest(new UnifiedChatInput((ChatCompletionInput)inputs, USER_ROLE), chatCompletionModel), ChatCompletionInput.class);
        String errorMessage = Ai21ActionCreator.buildErrorMessage(TaskType.COMPLETION, chatCompletionModel.getInferenceEntityId());
        return new SingleInputSenderExecutableAction(this.sender, manager, errorMessage, COMPLETION_ERROR_PREFIX);
    }

    public static String buildErrorMessage(TaskType requestType, String inferenceId) {
        return Strings.format((String)"Failed to send AI21 %s request from inference entity id [%s]", (Object[])new Object[]{requestType.toString(), inferenceId});
    }
}

