/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.lucene.codecs.hnsw.FlatVectorsReader;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.search.AcceptDocs;
import org.apache.lucene.search.KnnCollector;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.hnsw.RandomVectorScorer;
import org.elasticsearch.core.IOUtils;

public class MergeReaderWrapper
extends FlatVectorsReader {
    private final FlatVectorsReader mainReader;
    private final FlatVectorsReader mergeReader;

    public MergeReaderWrapper(FlatVectorsReader mainReader, FlatVectorsReader mergeReader) {
        super(mainReader.getFlatVectorScorer());
        this.mainReader = mainReader;
        this.mergeReader = mergeReader;
    }

    public RandomVectorScorer getRandomVectorScorer(String field, float[] target) throws IOException {
        return this.mainReader.getRandomVectorScorer(field, target);
    }

    public RandomVectorScorer getRandomVectorScorer(String field, byte[] target) throws IOException {
        return this.mainReader.getRandomVectorScorer(field, target);
    }

    public void checkIntegrity() throws IOException {
        this.mainReader.checkIntegrity();
    }

    public FloatVectorValues getFloatVectorValues(String field) throws IOException {
        return this.mainReader.getFloatVectorValues(field);
    }

    public ByteVectorValues getByteVectorValues(String field) throws IOException {
        return this.mainReader.getByteVectorValues(field);
    }

    public void search(String field, float[] target, KnnCollector knnCollector, AcceptDocs acceptDocs) throws IOException {
        this.mainReader.search(field, target, knnCollector, acceptDocs);
    }

    public void search(String field, byte[] target, KnnCollector knnCollector, AcceptDocs acceptDocs) throws IOException {
        this.mainReader.search(field, target, knnCollector, acceptDocs);
    }

    public FlatVectorsReader getMergeInstance() {
        return this.mergeReader;
    }

    public long ramBytesUsed() {
        return this.mainReader.ramBytesUsed();
    }

    public Collection<Accountable> getChildResources() {
        return this.mainReader.getChildResources();
    }

    public Map<String, Long> getOffHeapByteSize(FieldInfo fieldInfo) {
        return Map.of();
    }

    public void close() throws IOException {
        IOUtils.close((Closeable[])new Closeable[]{this.mainReader, this.mergeReader});
    }
}

