/**
 * MIT License
 *
 * Copyright (c) 2020-present, Elastic NV
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 */
import { Journey } from '../dsl/journey';
import { HooksCallback, RunOptions, JourneyResult, PushOptions } from '../common_types';
import { Monitor, MonitorConfig } from '../dsl/monitor';
type HookType = 'beforeAll' | 'afterAll';
export type SuiteHooks = Record<HookType, Array<HooksCallback>>;
type RunResult = Record<string, JourneyResult>;
export interface RunnerInfo {
    /**
     * Processed configuration from the CLI args and the config file
     */
    readonly config: RunOptions;
    /**
     * Currently active journey
     */
    readonly currentJourney: Journey | undefined;
    /**
     * All registerd journeys
     */
    readonly journeys: Journey[];
}
export default class Runner implements RunnerInfo {
    #private;
    config: RunOptions;
    get currentJourney(): Journey;
    get journeys(): Journey[];
    get hooks(): SuiteHooks;
    private captureScreenshot;
    _addHook(type: HookType, callback: HooksCallback): void;
    /**
     * @deprecated Since version Please do not rely on the internal methods.
     * Alias _addHook for backwards compatibility
     */
    addHook(type: HookType, callback: HooksCallback): void;
    private buildHookArgs;
    _updateMonitor(config: MonitorConfig): void;
    /**
     * @deprecated Since version Please do not rely on the internal methods.
     * Alias _addJourney for backwards compatibility
     */
    updateMonitor(config: MonitorConfig): void;
    _addJourney(journey: Journey): void;
    /**
     * @deprecated Since version 1.17.0. Please do not rely on the internal methods.
     * Alias _addJourney for backwards compatibility
     */
    addJourney(journey: Journey): void;
    private setReporter;
    _runJourney(journey: Journey, options: RunOptions): Promise<JourneyResult>;
    /**
     * @deprecated Since version 1.17.0. Please do not rely on the internal methods.
     * Alias _runJourney for backwards compatibility
     */
    runJourney(journey: Journey, options: RunOptions): void;
    _buildMonitors(options: PushOptions): Monitor[];
    /**
     * @deprecated Since version 1.17.0. Please do not rely on the internal methods.
     * Alias _buildMonitors for backwards compatibility
     */
    buildMonitors(options: PushOptions): void;
    _run(options: RunOptions): Promise<RunResult>;
    /**
     * @deprecated Since version 1.17.0. Please do not rely on the internal methods.
     * Alias _run for backwards compatibility
     */
    run(options: RunOptions): Promise<RunResult>;
    _runJourneys(options: RunOptions): Promise<RunResult>;
    /**
     * @deprecated Since version 1.17.0. Please do not rely on the internal methods.
     * Alias _runJourneys for backwards compatibility
     */
    runJourneys(options: RunOptions): Promise<RunResult>;
    _reset(): Promise<void>;
    /**
     * @deprecated Since version 1.17.0. Please do not rely on the internal methods.
     * Alias _reset for backwards compatibility
     */
    reset(): Promise<void>;
}
export {};
//# sourceMappingURL=runner.d.ts.map