/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.common.util.PageCacheRecycler;

public class BytesRefRecycler
implements Recycler<BytesRef> {
    public static final BytesRefRecycler NON_RECYCLING_INSTANCE = new BytesRefRecycler(PageCacheRecycler.NON_RECYCLING_INSTANCE);
    private final PageCacheRecycler recycler;

    public BytesRefRecycler(PageCacheRecycler recycler) {
        this.recycler = recycler;
    }

    @Override
    public Recycler.V<BytesRef> obtain() {
        final Recycler.V<byte[]> v = this.recycler.bytePage(false);
        final BytesRef bytesRef = new BytesRef(v.v(), 0, 16384);
        return new Recycler.V<BytesRef>(this){

            @Override
            public BytesRef v() {
                return bytesRef;
            }

            @Override
            public boolean isRecycled() {
                return v.isRecycled();
            }

            @Override
            public void close() {
                v.close();
            }
        };
    }

    @Override
    public int pageSize() {
        return 16384;
    }
}

