/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugins;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.store.Directory;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.EngineException;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardPath;
import org.elasticsearch.indices.cluster.IndexRemovalReason;
import org.elasticsearch.indices.recovery.RecoveryState;

public interface IndexStorePlugin {
    public Map<String, DirectoryFactory> getDirectoryFactories();

    default public Map<String, RecoveryStateFactory> getRecoveryStateFactories() {
        return Collections.emptyMap();
    }

    default public List<IndexFoldersDeletionListener> getIndexFoldersDeletionListeners() {
        return Collections.emptyList();
    }

    default public Map<String, SnapshotCommitSupplier> getSnapshotCommitSuppliers() {
        return Collections.emptyMap();
    }

    @FunctionalInterface
    public static interface SnapshotCommitSupplier {
        public Engine.IndexCommitRef acquireIndexCommitForSnapshot(Engine var1) throws EngineException;
    }

    public static interface IndexFoldersDeletionListener {
        public void beforeIndexFoldersDeleted(Index var1, IndexSettings var2, Path[] var3, IndexRemovalReason var4);

        public void beforeShardFoldersDeleted(ShardId var1, IndexSettings var2, Path[] var3, IndexRemovalReason var4);
    }

    @FunctionalInterface
    public static interface RecoveryStateFactory {
        public RecoveryState newRecoveryState(ShardRouting var1, DiscoveryNode var2, @Nullable DiscoveryNode var3);
    }

    @FunctionalInterface
    public static interface DirectoryFactory {
        public Directory newDirectory(IndexSettings var1, ShardPath var2) throws IOException;

        default public Directory newDirectory(IndexSettings indexSettings, ShardPath shardPath, ShardRouting shardRouting) throws IOException {
            return this.newDirectory(indexSettings, shardPath);
        }
    }
}

