/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.HashSet;
import java.util.Set;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.index.mapper.IgnoredSourceFieldMapper;

public record IgnoredFieldsSpec(Set<String> requiredIgnoredFields, IgnoredSourceFieldMapper.IgnoredSourceFormat format) {
    public static IgnoredFieldsSpec NONE = new IgnoredFieldsSpec(Set.of(), IgnoredSourceFieldMapper.IgnoredSourceFormat.NO_IGNORED_SOURCE);

    public boolean noRequirements() {
        return this.requiredIgnoredFields.isEmpty();
    }

    public IgnoredFieldsSpec merge(IgnoredFieldsSpec other) {
        if (this.format == IgnoredSourceFieldMapper.IgnoredSourceFormat.NO_IGNORED_SOURCE) {
            return other;
        }
        if (other.format == IgnoredSourceFieldMapper.IgnoredSourceFormat.NO_IGNORED_SOURCE) {
            return this;
        }
        if (other.requiredIgnoredFields.isEmpty()) {
            return this;
        }
        if (this.requiredIgnoredFields.isEmpty()) {
            return other;
        }
        if (this.format != other.format) {
            throw new ElasticsearchException("failed to merge IgnoredFieldsSpec with differing formats " + this.format.name() + "," + other.format.name(), new Object[0]);
        }
        HashSet<String> mergedFields = new HashSet<String>(this.requiredIgnoredFields);
        mergedFields.addAll(other.requiredIgnoredFields);
        return new IgnoredFieldsSpec(mergedFields, this.format);
    }

    public Set<String> requiredStoredFields() {
        return Set.of("_ignored_source");
    }
}

