/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.perfield;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.codecs.perfield.PerFieldDocValuesFormat;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValuesSkipper;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.internal.hppc.IntObjectHashMap;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.index.codec.perfield.XPerFieldMergeState;

public abstract class XPerFieldDocValuesFormat
extends DocValuesFormat {
    public static final String PER_FIELD_NAME = "ESPerFieldDV819";
    public static final String PER_FIELD_FORMAT_KEY = PerFieldDocValuesFormat.class.getSimpleName() + ".format";
    public static final String PER_FIELD_SUFFIX_KEY = PerFieldDocValuesFormat.class.getSimpleName() + ".suffix";

    protected XPerFieldDocValuesFormat() {
        super(PER_FIELD_NAME);
    }

    @Override
    public final DocValuesConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        return new FieldsWriter(state);
    }

    static String getSuffix(String formatName, String suffix) {
        return formatName + "_" + suffix;
    }

    static String getFullSegmentSuffix(String outerSegmentSuffix, String segmentSuffix) {
        if (outerSegmentSuffix.length() == 0) {
            return segmentSuffix;
        }
        return outerSegmentSuffix + "_" + segmentSuffix;
    }

    @Override
    public final DocValuesProducer fieldsProducer(SegmentReadState state) throws IOException {
        return new FieldsReader(state);
    }

    public abstract DocValuesFormat getDocValuesFormatForField(String var1);

    @SuppressForbidden(reason="forked from Lucene")
    private class FieldsWriter
    extends DocValuesConsumer {
        private final Map<DocValuesFormat, ConsumerAndSuffix> formats = new HashMap<DocValuesFormat, ConsumerAndSuffix>();
        private final Map<String, Integer> suffixes = new HashMap<String, Integer>();
        private final SegmentWriteState segmentWriteState;

        FieldsWriter(SegmentWriteState state) {
            this.segmentWriteState = state;
        }

        @Override
        public void addNumericField(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
            this.getInstance(field).addNumericField(field, valuesProducer);
        }

        @Override
        public void addBinaryField(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
            this.getInstance(field).addBinaryField(field, valuesProducer);
        }

        @Override
        public void addSortedField(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
            this.getInstance(field).addSortedField(field, valuesProducer);
        }

        @Override
        public void addSortedNumericField(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
            this.getInstance(field).addSortedNumericField(field, valuesProducer);
        }

        @Override
        public void addSortedSetField(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
            this.getInstance(field).addSortedSetField(field, valuesProducer);
        }

        @Override
        public void merge(MergeState mergeState) throws IOException {
            IdentityHashMap<DocValuesConsumer, ArrayList<String>> consumersToField = new IdentityHashMap<DocValuesConsumer, ArrayList<String>>();
            for (FieldInfo fieldInfo : mergeState.mergeFieldInfos) {
                if (fieldInfo.getDocValuesType() == DocValuesType.NONE) continue;
                DocValuesConsumer consumer = this.getInstance(fieldInfo, true);
                ArrayList<String> fieldsForConsumer = (ArrayList<String>)consumersToField.get(consumer);
                if (fieldsForConsumer == null) {
                    fieldsForConsumer = new ArrayList<String>();
                    consumersToField.put(consumer, fieldsForConsumer);
                }
                fieldsForConsumer.add(fieldInfo.name);
            }
            for (Map.Entry entry : consumersToField.entrySet()) {
                ((DocValuesConsumer)entry.getKey()).merge(XPerFieldMergeState.restrictFields(mergeState, (Collection)entry.getValue()));
            }
        }

        private DocValuesConsumer getInstance(FieldInfo field) throws IOException {
            return this.getInstance(field, false);
        }

        private DocValuesConsumer getInstance(FieldInfo field, boolean ignoreCurrentFormat) throws IOException {
            String formatName;
            DocValuesFormat format = null;
            if (field.getDocValuesGen() != -1L) {
                formatName = null;
                if (!ignoreCurrentFormat) {
                    formatName = field.getAttribute(PER_FIELD_FORMAT_KEY);
                }
                if (formatName != null) {
                    format = DocValuesFormat.forName(formatName);
                }
            }
            if (format == null) {
                format = XPerFieldDocValuesFormat.this.getDocValuesFormatForField(field.name);
            }
            if (format == null) {
                throw new IllegalStateException("invalid null DocValuesFormat for field=\"" + field.name + "\"");
            }
            formatName = format.getName();
            field.putAttribute(PER_FIELD_FORMAT_KEY, formatName);
            Integer suffix = null;
            ConsumerAndSuffix consumer = this.formats.get(format);
            if (consumer == null) {
                if (field.getDocValuesGen() != -1L) {
                    String suffixAtt = null;
                    if (!ignoreCurrentFormat) {
                        suffixAtt = field.getAttribute(PER_FIELD_SUFFIX_KEY);
                    }
                    if (suffixAtt != null) {
                        suffix = Integer.valueOf(suffixAtt);
                    }
                }
                if (suffix == null) {
                    suffix = this.suffixes.get(formatName);
                    suffix = suffix == null ? Integer.valueOf(0) : Integer.valueOf(suffix + 1);
                }
                this.suffixes.put(formatName, suffix);
                String segmentSuffix = XPerFieldDocValuesFormat.getFullSegmentSuffix(this.segmentWriteState.segmentSuffix, XPerFieldDocValuesFormat.getSuffix(formatName, Integer.toString(suffix)));
                consumer = new ConsumerAndSuffix(format.fieldsConsumer(new SegmentWriteState(this.segmentWriteState, segmentSuffix)), suffix);
                this.formats.put(format, consumer);
            } else {
                assert (this.suffixes.containsKey(formatName));
                suffix = consumer.suffix;
            }
            field.putAttribute(PER_FIELD_SUFFIX_KEY, Integer.toString(suffix));
            return consumer.consumer;
        }

        @Override
        public void close() throws IOException {
            IOUtils.close(this.formats.values());
        }
    }

    @SuppressForbidden(reason="forked from Lucene")
    public static class FieldsReader
    extends DocValuesProducer {
        private final IntObjectHashMap<DocValuesProducer> fields = new IntObjectHashMap();
        private final Map<String, DocValuesProducer> formats = new HashMap<String, DocValuesProducer>();

        FieldsReader(FieldsReader other) {
            IdentityHashMap<DocValuesProducer, DocValuesProducer> oldToNew = new IdentityHashMap<DocValuesProducer, DocValuesProducer>();
            for (Map.Entry<String, DocValuesProducer> entry : other.formats.entrySet()) {
                DocValuesProducer values = entry.getValue().getMergeInstance();
                this.formats.put(entry.getKey(), values);
                oldToNew.put(entry.getValue(), values);
            }
            for (IntObjectHashMap.IntObjectCursor intObjectCursor : other.fields) {
                DocValuesProducer producer = (DocValuesProducer)oldToNew.get(intObjectCursor.value);
                assert (producer != null);
                this.fields.put(intObjectCursor.key, producer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        FieldsReader(SegmentReadState readState) throws IOException {
            boolean success = false;
            try {
                for (FieldInfo fi : readState.fieldInfos) {
                    if (fi.getDocValuesType() == DocValuesType.NONE) continue;
                    String fieldName = fi.name;
                    String formatName = fi.getAttribute(PER_FIELD_FORMAT_KEY);
                    if (formatName == null) continue;
                    String suffix = fi.getAttribute(PER_FIELD_SUFFIX_KEY);
                    if (suffix == null) {
                        throw new IllegalStateException("missing attribute: " + PER_FIELD_SUFFIX_KEY + " for field: " + fieldName);
                    }
                    DocValuesFormat format = DocValuesFormat.forName(formatName);
                    String segmentSuffix = XPerFieldDocValuesFormat.getFullSegmentSuffix(readState.segmentSuffix, XPerFieldDocValuesFormat.getSuffix(formatName, suffix));
                    if (!this.formats.containsKey(segmentSuffix)) {
                        this.formats.put(segmentSuffix, format.fieldsProducer(new SegmentReadState(readState, segmentSuffix)));
                    }
                    this.fields.put(fi.number, this.formats.get(segmentSuffix));
                }
                success = true;
            }
            finally {
                if (!success) {
                    IOUtils.closeWhileHandlingException(this.formats.values());
                }
            }
        }

        public DocValuesProducer getDocValuesProducer(FieldInfo field) {
            return this.fields.get(field.number);
        }

        public Map<String, DocValuesProducer> getFormats() {
            return this.formats;
        }

        @Override
        public NumericDocValues getNumeric(FieldInfo field) throws IOException {
            DocValuesProducer producer = this.fields.get(field.number);
            return producer == null ? null : producer.getNumeric(field);
        }

        @Override
        public BinaryDocValues getBinary(FieldInfo field) throws IOException {
            DocValuesProducer producer = this.fields.get(field.number);
            return producer == null ? null : producer.getBinary(field);
        }

        @Override
        public SortedDocValues getSorted(FieldInfo field) throws IOException {
            DocValuesProducer producer = this.fields.get(field.number);
            return producer == null ? null : producer.getSorted(field);
        }

        @Override
        public SortedNumericDocValues getSortedNumeric(FieldInfo field) throws IOException {
            DocValuesProducer producer = this.fields.get(field.number);
            return producer == null ? null : producer.getSortedNumeric(field);
        }

        @Override
        public SortedSetDocValues getSortedSet(FieldInfo field) throws IOException {
            DocValuesProducer producer = this.fields.get(field.number);
            return producer == null ? null : producer.getSortedSet(field);
        }

        @Override
        public DocValuesSkipper getSkipper(FieldInfo field) throws IOException {
            DocValuesProducer producer = this.fields.get(field.number);
            return producer == null ? null : producer.getSkipper(field);
        }

        @Override
        public void close() throws IOException {
            IOUtils.close(this.formats.values());
        }

        @Override
        public void checkIntegrity() throws IOException {
            for (DocValuesProducer format : this.formats.values()) {
                format.checkIntegrity();
            }
        }

        @Override
        public DocValuesProducer getMergeInstance() {
            return new FieldsReader(this);
        }

        public String toString() {
            return "PerFieldDocValues(formats=" + this.formats.size() + ")";
        }
    }

    record ConsumerAndSuffix(DocValuesConsumer consumer, int suffix) implements Closeable
    {
        @Override
        public void close() throws IOException {
            this.consumer.close();
        }
    }
}

