/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway;

import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.GlobalRoutingTable;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRoutingRoleStrategy;
import org.elasticsearch.cluster.version.CompatibilityVersions;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.core.Strings;
import org.elasticsearch.gateway.GatewayService;

public class ClusterStateUpdaters {
    private static final Logger logger = LogManager.getLogger(ClusterStateUpdaters.class);

    public static ClusterState setLocalNode(ClusterState clusterState, DiscoveryNode localNode, CompatibilityVersions compatibilityVersions) {
        return ClusterState.builder(clusterState).nodes(DiscoveryNodes.builder().add(localNode).localNodeId(localNode.getId()).build()).putCompatibilityVersions(localNode.getId(), compatibilityVersions).build();
    }

    public static ClusterState upgradeAndArchiveUnknownOrInvalidSettings(ClusterState clusterState, ClusterSettings clusterSettings) {
        Metadata.Builder metadataBuilder = Metadata.builder(clusterState.metadata());
        metadataBuilder.persistentSettings(clusterSettings.archiveUnknownOrInvalidSettings(metadataBuilder.persistentSettings(), e -> ClusterStateUpdaters.logUnknownSetting("persistent", e), (e, ex) -> ClusterStateUpdaters.logInvalidSetting("persistent", e, ex)));
        metadataBuilder.transientSettings(clusterSettings.archiveUnknownOrInvalidSettings(metadataBuilder.transientSettings(), e -> ClusterStateUpdaters.logUnknownSetting("transient", e), (e, ex) -> ClusterStateUpdaters.logInvalidSetting("transient", e, ex)));
        return ClusterState.builder(clusterState).metadata(metadataBuilder).build();
    }

    private static void logUnknownSetting(String settingType, Map.Entry<String, String> e) {
        logger.warn("ignoring unknown {} setting: [{}] with value [{}]; archiving", (Object)settingType, (Object)e.getKey(), (Object)e.getValue());
    }

    private static void logInvalidSetting(String settingType, Map.Entry<String, String> e, IllegalArgumentException ex) {
        logger.warn(() -> Strings.format("ignoring invalid %s setting: [%s] with value [%s]; archiving", settingType, e.getKey(), e.getValue()), (Throwable)ex);
    }

    public static ClusterState recoverClusterBlocks(ClusterState state) {
        ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(state.blocks());
        if (Metadata.SETTING_READ_ONLY_SETTING.get(state.metadata().settings()).booleanValue()) {
            blocks.addGlobalBlock(Metadata.CLUSTER_READ_ONLY_BLOCK);
        }
        if (Metadata.SETTING_READ_ONLY_ALLOW_DELETE_SETTING.get(state.metadata().settings()).booleanValue()) {
            blocks.addGlobalBlock(Metadata.CLUSTER_READ_ONLY_ALLOW_DELETE_BLOCK);
        }
        state.forEachProject(projectState -> {
            for (IndexMetadata indexMetadata : projectState.metadata()) {
                blocks.addBlocks(projectState.projectId(), indexMetadata);
            }
        });
        return ClusterState.builder(state).blocks(blocks).build();
    }

    static ClusterState updateRoutingTable(ClusterState state, ShardRoutingRoleStrategy shardRoutingRoleStrategy) {
        GlobalRoutingTable.Builder globalRoutingTableBuilder = GlobalRoutingTable.builder(state.globalRoutingTable());
        for (ProjectMetadata projectMetadata : state.metadata().projects().values()) {
            RoutingTable.Builder routingTableBuilder = RoutingTable.builder(shardRoutingRoleStrategy, state.routingTable(projectMetadata.id()));
            for (IndexMetadata indexMetadata : projectMetadata) {
                routingTableBuilder.addAsRecovery(indexMetadata);
            }
            globalRoutingTableBuilder.put(projectMetadata.id(), routingTableBuilder);
        }
        return ClusterState.builder(state).routingTable(globalRoutingTableBuilder.build()).build();
    }

    static ClusterState removeStateNotRecoveredBlock(ClusterState state) {
        return ClusterState.builder(state).blocks(ClusterBlocks.builder().blocks(state.blocks()).removeGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK).build()).build();
    }

    public static ClusterState addStateNotRecoveredBlock(ClusterState state) {
        return ClusterState.builder(state).blocks(ClusterBlocks.builder().blocks(state.blocks()).addGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK).build()).build();
    }

    static ClusterState mixCurrentStateAndRecoveredState(ClusterState currentState, ClusterState recoveredState) {
        assert (currentState.metadata().getTotalNumberOfIndices() == 0);
        ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks()).blocks(recoveredState.blocks());
        Metadata.Builder metadataBuilder = Metadata.builder(recoveredState.metadata());
        metadataBuilder.generateClusterUuidIfNeeded();
        for (ProjectMetadata projectMetadata : recoveredState.metadata().projects().values()) {
            for (IndexMetadata indexMetadata : projectMetadata) {
                metadataBuilder.getProject(projectMetadata.id()).put(indexMetadata, false);
            }
        }
        return ClusterState.builder(currentState).blocks(blocks).metadata(metadataBuilder).build();
    }

    public static ClusterState hideStateIfNotRecovered(ClusterState state) {
        if (state.blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(state.blocks());
            blocks.removeGlobalBlock(Metadata.CLUSTER_READ_ONLY_BLOCK);
            blocks.removeGlobalBlock(Metadata.CLUSTER_READ_ONLY_ALLOW_DELETE_BLOCK);
            state.forEachProject(projectState -> {
                for (IndexMetadata indexMetadata : projectState.metadata()) {
                    blocks.removeIndexBlocks(projectState.projectId(), indexMetadata.getIndex().getName());
                }
            });
            Metadata metadata = Metadata.builder().clusterUUID(state.metadata().clusterUUID()).coordinationMetadata(state.metadata().coordinationMetadata()).build();
            assert (!state.globalRoutingTable().hasIndices()) : "routing table is not empty: " + String.valueOf(state.globalRoutingTable().routingTables());
            GlobalRoutingTable.Builder globalRoutingTableBuilder = GlobalRoutingTable.builder();
            metadata.projects().keySet().forEach(projectId -> globalRoutingTableBuilder.put((ProjectId)projectId, RoutingTable.EMPTY_ROUTING_TABLE));
            return ClusterState.builder(state).routingTable(globalRoutingTableBuilder.build()).metadata(metadata).blocks(blocks.build()).build();
        }
        return state;
    }
}

