/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.datastreams;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.local.LocalClusterStateRequest;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ChunkedToXContentObject;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class GetDataStreamSettingsAction
extends ActionType<Response> {
    public static final String NAME = "indices:monitor/data_stream/settings/get";
    public static final GetDataStreamSettingsAction INSTANCE = new GetDataStreamSettingsAction();

    public GetDataStreamSettingsAction() {
        super(NAME);
    }

    public record DataStreamSettingsResponse(String dataStreamName, Settings settings, Settings effectiveSettings) implements ToXContent
    {
        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("name", this.dataStreamName);
            builder.startObject("settings");
            this.settings.toXContent(builder, params);
            builder.endObject();
            builder.startObject("effective_settings");
            this.effectiveSettings.toXContent(builder, params);
            builder.endObject();
            builder.endObject();
            return builder;
        }
    }

    public static class Response
    extends ActionResponse
    implements ChunkedToXContentObject {
        private final List<DataStreamSettingsResponse> dataStreamSettingsResponses;

        public Response(List<DataStreamSettingsResponse> dataStreamSettingsResponses) {
            this.dataStreamSettingsResponses = dataStreamSettingsResponses;
        }

        public List<DataStreamSettingsResponse> getDataStreamSettingsResponses() {
            return this.dataStreamSettingsResponses;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            assert (false) : "This ought to never be called because this action only runs locally";
        }

        @Override
        public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
            return Iterators.concat(Iterators.single((builder, params1) -> builder.startObject().startArray("data_streams")), this.dataStreamSettingsResponses.stream().map(dataStreamSettingsResponse -> dataStreamSettingsResponse).iterator(), Iterators.single((builder, params1) -> builder.endArray().endObject()));
        }
    }

    public static class Request
    extends LocalClusterStateRequest
    implements IndicesRequest.Replaceable {
        private String[] dataStreamNames;

        public Request(TimeValue masterNodeTimeout) {
            super(masterNodeTimeout);
        }

        @Override
        public Request indices(String ... dataStreamNames) {
            this.dataStreamNames = dataStreamNames;
            return this;
        }

        @Override
        public boolean includeDataStreams() {
            return true;
        }

        @Override
        public String[] indices() {
            return this.dataStreamNames;
        }

        @Override
        public IndicesOptions indicesOptions() {
            return IndicesOptions.LENIENT_EXPAND_OPEN_CLOSED;
        }

        @Override
        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new CancellableTask(id, type, action, "", parentTaskId, headers);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return Arrays.equals(this.dataStreamNames, request.dataStreamNames);
        }

        public int hashCode() {
            return Arrays.hashCode(this.dataStreamNames);
        }
    }
}

