/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.readonly;

import java.util.Arrays;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.admin.indices.readonly.RemoveIndexBlockRequest;
import org.elasticsearch.action.admin.indices.readonly.RemoveIndexBlockResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.DestructiveOperations;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateAckListener;
import org.elasticsearch.cluster.SimpleBatchedAckListenerTaskExecutor;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetadataIndexStateService;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.cluster.service.MasterServiceTaskQueue;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.Index;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportRemoveIndexBlockAction
extends TransportMasterNodeAction<RemoveIndexBlockRequest, RemoveIndexBlockResponse> {
    public static final ActionType<RemoveIndexBlockResponse> TYPE = new ActionType("indices:admin/block/remove");
    private final ProjectResolver projectResolver;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final DestructiveOperations destructiveOperations;
    private final MasterServiceTaskQueue<AckedClusterStateUpdateTask> removeBlocksQueue;

    @Inject
    public TransportRemoveIndexBlockAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, ProjectResolver projectResolver, IndexNameExpressionResolver indexNameExpressionResolver, DestructiveOperations destructiveOperations) {
        super(TYPE.name(), transportService, clusterService, threadPool, actionFilters, RemoveIndexBlockRequest::new, RemoveIndexBlockResponse::new, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.projectResolver = projectResolver;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.destructiveOperations = destructiveOperations;
        this.removeBlocksQueue = clusterService.createTaskQueue("remove-blocks", Priority.URGENT, new SimpleBatchedAckListenerTaskExecutor<AckedClusterStateUpdateTask>(this){

            @Override
            public Tuple<ClusterState, ClusterStateAckListener> executeTask(AckedClusterStateUpdateTask task, ClusterState clusterState) throws Exception {
                return Tuple.tuple(task.execute(clusterState), task);
            }
        });
    }

    @Override
    protected void doExecute(Task task, RemoveIndexBlockRequest request, ActionListener<RemoveIndexBlockResponse> listener) {
        this.destructiveOperations.failDestructive(request.indices());
        super.doExecute(task, request, listener);
    }

    @Override
    protected ClusterBlockException checkBlock(RemoveIndexBlockRequest request, ClusterState state) {
        if (request.getBlock().getBlock().levels().contains((Object)ClusterBlockLevel.METADATA_WRITE) && state.blocks().global(ClusterBlockLevel.METADATA_WRITE).isEmpty()) {
            return null;
        }
        ProjectMetadata projectMetadata = this.projectResolver.getProjectMetadata(state);
        return state.blocks().indicesBlockedException(projectMetadata.id(), ClusterBlockLevel.METADATA_WRITE, this.indexNameExpressionResolver.concreteIndexNames(projectMetadata, (IndicesRequest)request));
    }

    @Override
    protected void masterOperation(Task task, RemoveIndexBlockRequest request, ClusterState state, ActionListener<RemoveIndexBlockResponse> listener) throws Exception {
        Object[] concreteIndices = this.indexNameExpressionResolver.concreteIndices(state, (IndicesRequest)request);
        if (concreteIndices == null || concreteIndices.length == 0) {
            listener.onResponse(RemoveIndexBlockResponse.EMPTY);
            return;
        }
        final ProjectId projectId = this.projectResolver.getProjectId();
        this.removeBlocksQueue.submitTask("remove-index-block-[" + request.getBlock().toString() + "]-" + Arrays.toString(concreteIndices), new AckedClusterStateUpdateTask(this, request, listener, (Index[])concreteIndices, request){
            private List<RemoveIndexBlockResponse.RemoveBlockResult> results;
            final /* synthetic */ Index[] val$concreteIndices;
            final /* synthetic */ RemoveIndexBlockRequest val$request;
            {
                this.val$concreteIndices = indexArray;
                this.val$request = removeIndexBlockRequest;
                super(request, listener);
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                Tuple<ClusterState, List<RemoveIndexBlockResponse.RemoveBlockResult>> tuple = MetadataIndexStateService.removeIndexBlock(currentState.projectState(projectId), this.val$concreteIndices, this.val$request.getBlock());
                this.results = tuple.v2();
                return tuple.v1();
            }

            @Override
            protected AcknowledgedResponse newResponse(boolean acknowledged) {
                return new RemoveIndexBlockResponse(acknowledged, this.results);
            }
        }, request.masterNodeTimeout());
    }
}

