/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.transport.rest_client;

import co.elastic.clients.transport.TransportOptions;
import co.elastic.clients.transport.http.TransportHttpClient;
import co.elastic.clients.transport.rest_client.MultiBufferEntity;
import co.elastic.clients.transport.rest_client.RestClientOptions;
import co.elastic.clients.util.BinaryData;
import co.elastic.clients.util.NoCopyByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.AbstractList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Cancellable;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseListener;
import org.elasticsearch.client.RestClient;

public class RestClientHttpClient
implements TransportHttpClient {
    private static final ConcurrentHashMap<String, ContentType> ContentTypeCache = new ConcurrentHashMap();
    private final RestClient restClient;

    public RestClientHttpClient(RestClient restClient) {
        this.restClient = restClient;
    }

    public RestClient restClient() {
        return this.restClient;
    }

    @Override
    public RestClientOptions createOptions(@Nullable TransportOptions options) {
        return RestClientOptions.of(options);
    }

    @Override
    public TransportHttpClient.Response performRequest(String endpointId, @Nullable TransportHttpClient.Node node, TransportHttpClient.Request request, TransportOptions options) throws IOException {
        RestClientOptions rcOptions = RestClientOptions.of(options);
        Request restRequest = this.createRestRequest(request, rcOptions);
        Response restResponse = this.restClient.performRequest(restRequest);
        return new RestResponse(restResponse);
    }

    @Override
    public CompletableFuture<TransportHttpClient.Response> performRequestAsync(String endpointId, @Nullable TransportHttpClient.Node node, TransportHttpClient.Request request, TransportOptions options) {
        Request restRequest;
        final RequestFuture<TransportHttpClient.Response> future = new RequestFuture<TransportHttpClient.Response>();
        try {
            RestClientOptions rcOptions = RestClientOptions.of(options);
            restRequest = this.createRestRequest(request, rcOptions);
        }
        catch (Throwable thr) {
            future.completeExceptionally(thr);
            return future;
        }
        ((RequestFuture)future).cancellable = this.restClient.performRequestAsync(restRequest, new ResponseListener(){

            @Override
            public void onSuccess(Response response) {
                future.complete(new RestResponse(response));
            }

            @Override
            public void onFailure(Exception exception) {
                future.completeExceptionally(exception);
            }
        });
        return future;
    }

    @Override
    public void close() throws IOException {
        this.restClient.close();
    }

    private Request createRestRequest(TransportHttpClient.Request request, RestClientOptions options) {
        Request clientReq = new Request(request.method(), request.path());
        Iterable<ByteBuffer> body = request.body();
        Map<String, String> requestHeaders = request.headers();
        if (!requestHeaders.isEmpty()) {
            int headerCount = requestHeaders.size();
            if (body == null && headerCount != 3 || headerCount != 4) {
                if (options == null) {
                    options = RestClientOptions.initialOptions();
                }
                RestClientOptions.Builder builder = options.toBuilder();
                for (Map.Entry<String, String> header : requestHeaders.entrySet()) {
                    builder.setHeader(header.getKey(), header.getValue());
                }
                for (Map.Entry<String, String> header : options.headers()) {
                    builder.setHeader(header.getKey(), header.getValue());
                }
                options = builder.build();
            }
        }
        if (options != null) {
            clientReq.setOptions(options.restClientRequestOptions());
        }
        clientReq.addParameters(request.queryParams());
        if (body != null) {
            ContentType ct = null;
            String ctStr = requestHeaders.get("Content-Type");
            if (ctStr != null) {
                ct = ContentTypeCache.computeIfAbsent(ctStr, ContentType::parse);
            }
            clientReq.setEntity(new MultiBufferEntity(body, ct));
        }
        clientReq.addParameter("ignore", "400,401,403,404,405");
        return clientReq;
    }

    static class RestResponse
    implements TransportHttpClient.Response {
        private final Response restResponse;

        RestResponse(Response restResponse) {
            this.restResponse = restResponse;
        }

        @Override
        public TransportHttpClient.Node node() {
            return new TransportHttpClient.Node(this.restResponse.getHost().toURI());
        }

        @Override
        public int statusCode() {
            return this.restResponse.getStatusLine().getStatusCode();
        }

        @Override
        public String header(String name) {
            return this.restResponse.getHeader(name);
        }

        @Override
        public List<String> headers(String name) {
            Header[] headers = this.restResponse.getHeaders();
            for (int i = 0; i < headers.length; ++i) {
                Header header = headers[i];
                if (!header.getName().equalsIgnoreCase(name)) continue;
                final HeaderElement[] elements = header.getElements();
                return new AbstractList<String>(){

                    @Override
                    public String get(int index) {
                        return elements[index].getValue();
                    }

                    @Override
                    public int size() {
                        return elements.length;
                    }
                };
            }
            return Collections.emptyList();
        }

        @Override
        @Nullable
        public BinaryData body() throws IOException {
            HttpEntity entity = this.restResponse.getEntity();
            return entity == null ? null : new HttpEntityBinaryData(this.restResponse.getEntity());
        }

        @Override
        @Nullable
        public Response originalResponse() {
            return this.restResponse;
        }

        @Override
        public void close() throws IOException {
            EntityUtils.consume(this.restResponse.getEntity());
        }
    }

    private static class RequestFuture<T>
    extends CompletableFuture<T> {
        private volatile Cancellable cancellable;

        private RequestFuture() {
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean cancelled = super.cancel(mayInterruptIfRunning);
            if (cancelled && this.cancellable != null) {
                this.cancellable.cancel();
            }
            return cancelled;
        }
    }

    private static class HttpEntityBinaryData
    implements BinaryData {
        private final HttpEntity entity;

        HttpEntityBinaryData(HttpEntity entity) {
            this.entity = entity;
        }

        @Override
        public String contentType() {
            Header h = this.entity.getContentType();
            return h == null ? "application/octet-stream" : h.getValue();
        }

        @Override
        public void writeTo(OutputStream out) throws IOException {
            this.entity.writeTo(out);
        }

        @Override
        public ByteBuffer asByteBuffer() throws IOException {
            NoCopyByteArrayOutputStream out = new NoCopyByteArrayOutputStream();
            this.entity.writeTo(out);
            return out.asByteBuffer();
        }

        @Override
        public InputStream asInputStream() throws IOException {
            return this.entity.getContent();
        }

        @Override
        public boolean isRepeatable() {
            return this.entity.isRepeatable();
        }

        @Override
        public long size() {
            long len = this.entity.getContentLength();
            return len < 0L ? -1L : this.entity.getContentLength();
        }
    }
}

