/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ClusterStateUpdate
implements JsonpSerializable {
    private final long count;
    @Nullable
    private final Time computationTime;
    @Nullable
    private final Long computationTimeMillis;
    @Nullable
    private final Time publicationTime;
    @Nullable
    private final Long publicationTimeMillis;
    @Nullable
    private final Time contextConstructionTime;
    @Nullable
    private final Long contextConstructionTimeMillis;
    @Nullable
    private final Time commitTime;
    @Nullable
    private final Long commitTimeMillis;
    @Nullable
    private final Time completionTime;
    @Nullable
    private final Long completionTimeMillis;
    @Nullable
    private final Time masterApplyTime;
    @Nullable
    private final Long masterApplyTimeMillis;
    @Nullable
    private final Time notificationTime;
    @Nullable
    private final Long notificationTimeMillis;
    public static final JsonpDeserializer<ClusterStateUpdate> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClusterStateUpdate::setupClusterStateUpdateDeserializer);

    private ClusterStateUpdate(Builder builder) {
        this.count = ApiTypeHelper.requireNonNull(builder.count, (Object)this, "count", 0L);
        this.computationTime = builder.computationTime;
        this.computationTimeMillis = builder.computationTimeMillis;
        this.publicationTime = builder.publicationTime;
        this.publicationTimeMillis = builder.publicationTimeMillis;
        this.contextConstructionTime = builder.contextConstructionTime;
        this.contextConstructionTimeMillis = builder.contextConstructionTimeMillis;
        this.commitTime = builder.commitTime;
        this.commitTimeMillis = builder.commitTimeMillis;
        this.completionTime = builder.completionTime;
        this.completionTimeMillis = builder.completionTimeMillis;
        this.masterApplyTime = builder.masterApplyTime;
        this.masterApplyTimeMillis = builder.masterApplyTimeMillis;
        this.notificationTime = builder.notificationTime;
        this.notificationTimeMillis = builder.notificationTimeMillis;
    }

    public static ClusterStateUpdate of(Function<Builder, ObjectBuilder<ClusterStateUpdate>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long count() {
        return this.count;
    }

    @Nullable
    public final Time computationTime() {
        return this.computationTime;
    }

    @Nullable
    public final Long computationTimeMillis() {
        return this.computationTimeMillis;
    }

    @Nullable
    public final Time publicationTime() {
        return this.publicationTime;
    }

    @Nullable
    public final Long publicationTimeMillis() {
        return this.publicationTimeMillis;
    }

    @Nullable
    public final Time contextConstructionTime() {
        return this.contextConstructionTime;
    }

    @Nullable
    public final Long contextConstructionTimeMillis() {
        return this.contextConstructionTimeMillis;
    }

    @Nullable
    public final Time commitTime() {
        return this.commitTime;
    }

    @Nullable
    public final Long commitTimeMillis() {
        return this.commitTimeMillis;
    }

    @Nullable
    public final Time completionTime() {
        return this.completionTime;
    }

    @Nullable
    public final Long completionTimeMillis() {
        return this.completionTimeMillis;
    }

    @Nullable
    public final Time masterApplyTime() {
        return this.masterApplyTime;
    }

    @Nullable
    public final Long masterApplyTimeMillis() {
        return this.masterApplyTimeMillis;
    }

    @Nullable
    public final Time notificationTime() {
        return this.notificationTime;
    }

    @Nullable
    public final Long notificationTimeMillis() {
        return this.notificationTimeMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("count");
        generator.write(this.count);
        if (this.computationTime != null) {
            generator.writeKey("computation_time");
            this.computationTime.serialize(generator, mapper);
        }
        if (this.computationTimeMillis != null) {
            generator.writeKey("computation_time_millis");
            generator.write(this.computationTimeMillis);
        }
        if (this.publicationTime != null) {
            generator.writeKey("publication_time");
            this.publicationTime.serialize(generator, mapper);
        }
        if (this.publicationTimeMillis != null) {
            generator.writeKey("publication_time_millis");
            generator.write(this.publicationTimeMillis);
        }
        if (this.contextConstructionTime != null) {
            generator.writeKey("context_construction_time");
            this.contextConstructionTime.serialize(generator, mapper);
        }
        if (this.contextConstructionTimeMillis != null) {
            generator.writeKey("context_construction_time_millis");
            generator.write(this.contextConstructionTimeMillis);
        }
        if (this.commitTime != null) {
            generator.writeKey("commit_time");
            this.commitTime.serialize(generator, mapper);
        }
        if (this.commitTimeMillis != null) {
            generator.writeKey("commit_time_millis");
            generator.write(this.commitTimeMillis);
        }
        if (this.completionTime != null) {
            generator.writeKey("completion_time");
            this.completionTime.serialize(generator, mapper);
        }
        if (this.completionTimeMillis != null) {
            generator.writeKey("completion_time_millis");
            generator.write(this.completionTimeMillis);
        }
        if (this.masterApplyTime != null) {
            generator.writeKey("master_apply_time");
            this.masterApplyTime.serialize(generator, mapper);
        }
        if (this.masterApplyTimeMillis != null) {
            generator.writeKey("master_apply_time_millis");
            generator.write(this.masterApplyTimeMillis);
        }
        if (this.notificationTime != null) {
            generator.writeKey("notification_time");
            this.notificationTime.serialize(generator, mapper);
        }
        if (this.notificationTimeMillis != null) {
            generator.writeKey("notification_time_millis");
            generator.write(this.notificationTimeMillis);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupClusterStateUpdateDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count");
        op.add(Builder::computationTime, Time._DESERIALIZER, "computation_time");
        op.add(Builder::computationTimeMillis, JsonpDeserializer.longDeserializer(), "computation_time_millis");
        op.add(Builder::publicationTime, Time._DESERIALIZER, "publication_time");
        op.add(Builder::publicationTimeMillis, JsonpDeserializer.longDeserializer(), "publication_time_millis");
        op.add(Builder::contextConstructionTime, Time._DESERIALIZER, "context_construction_time");
        op.add(Builder::contextConstructionTimeMillis, JsonpDeserializer.longDeserializer(), "context_construction_time_millis");
        op.add(Builder::commitTime, Time._DESERIALIZER, "commit_time");
        op.add(Builder::commitTimeMillis, JsonpDeserializer.longDeserializer(), "commit_time_millis");
        op.add(Builder::completionTime, Time._DESERIALIZER, "completion_time");
        op.add(Builder::completionTimeMillis, JsonpDeserializer.longDeserializer(), "completion_time_millis");
        op.add(Builder::masterApplyTime, Time._DESERIALIZER, "master_apply_time");
        op.add(Builder::masterApplyTimeMillis, JsonpDeserializer.longDeserializer(), "master_apply_time_millis");
        op.add(Builder::notificationTime, Time._DESERIALIZER, "notification_time");
        op.add(Builder::notificationTimeMillis, JsonpDeserializer.longDeserializer(), "notification_time_millis");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ClusterStateUpdate> {
        private Long count;
        @Nullable
        private Time computationTime;
        @Nullable
        private Long computationTimeMillis;
        @Nullable
        private Time publicationTime;
        @Nullable
        private Long publicationTimeMillis;
        @Nullable
        private Time contextConstructionTime;
        @Nullable
        private Long contextConstructionTimeMillis;
        @Nullable
        private Time commitTime;
        @Nullable
        private Long commitTimeMillis;
        @Nullable
        private Time completionTime;
        @Nullable
        private Long completionTimeMillis;
        @Nullable
        private Time masterApplyTime;
        @Nullable
        private Long masterApplyTimeMillis;
        @Nullable
        private Time notificationTime;
        @Nullable
        private Long notificationTimeMillis;

        public final Builder count(long value) {
            this.count = value;
            return this;
        }

        public final Builder computationTime(@Nullable Time value) {
            this.computationTime = value;
            return this;
        }

        public final Builder computationTime(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.computationTime(fn.apply(new Time.Builder()).build());
        }

        public final Builder computationTimeMillis(@Nullable Long value) {
            this.computationTimeMillis = value;
            return this;
        }

        public final Builder publicationTime(@Nullable Time value) {
            this.publicationTime = value;
            return this;
        }

        public final Builder publicationTime(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.publicationTime(fn.apply(new Time.Builder()).build());
        }

        public final Builder publicationTimeMillis(@Nullable Long value) {
            this.publicationTimeMillis = value;
            return this;
        }

        public final Builder contextConstructionTime(@Nullable Time value) {
            this.contextConstructionTime = value;
            return this;
        }

        public final Builder contextConstructionTime(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.contextConstructionTime(fn.apply(new Time.Builder()).build());
        }

        public final Builder contextConstructionTimeMillis(@Nullable Long value) {
            this.contextConstructionTimeMillis = value;
            return this;
        }

        public final Builder commitTime(@Nullable Time value) {
            this.commitTime = value;
            return this;
        }

        public final Builder commitTime(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.commitTime(fn.apply(new Time.Builder()).build());
        }

        public final Builder commitTimeMillis(@Nullable Long value) {
            this.commitTimeMillis = value;
            return this;
        }

        public final Builder completionTime(@Nullable Time value) {
            this.completionTime = value;
            return this;
        }

        public final Builder completionTime(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.completionTime(fn.apply(new Time.Builder()).build());
        }

        public final Builder completionTimeMillis(@Nullable Long value) {
            this.completionTimeMillis = value;
            return this;
        }

        public final Builder masterApplyTime(@Nullable Time value) {
            this.masterApplyTime = value;
            return this;
        }

        public final Builder masterApplyTime(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterApplyTime(fn.apply(new Time.Builder()).build());
        }

        public final Builder masterApplyTimeMillis(@Nullable Long value) {
            this.masterApplyTimeMillis = value;
            return this;
        }

        public final Builder notificationTime(@Nullable Time value) {
            this.notificationTime = value;
            return this;
        }

        public final Builder notificationTime(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.notificationTime(fn.apply(new Time.Builder()).build());
        }

        public final Builder notificationTimeMillis(@Nullable Long value) {
            this.notificationTimeMillis = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ClusterStateUpdate build() {
            this._checkSingleUse();
            return new ClusterStateUpdate(this);
        }
    }
}

