"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExceptionsTableUtilityBar = void 0;
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _utility_bar = require("../../../common/components/utility_bar");
var i18n = _interopRequireWildcard(require("../../translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/exceptions/components/shared_list_utilty_bar/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ExceptionsTableUtilityBar = ({
  onRefresh,
  totalExceptionLists,
  setSort,
  sort,
  sortFields
}) => {
  var _sortFields$find;
  const selectedSortField = sortFields === null || sortFields === void 0 ? void 0 : sortFields.find(sortField => sortField.field === (sort === null || sort === void 0 ? void 0 : sort.field));
  return /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBar, {
    border: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarSection, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarText, {
    dataTestSubj: "showingExceptionLists",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 11
    }
  }, i18n.SHOWING_EXCEPTION_LISTS(totalExceptionLists))), /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarAction, {
    dataTestSubj: "refreshRulesAction",
    iconSide: "left",
    iconType: "refresh",
    onClick: onRefresh,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 11
    }
  }, i18n.REFRESH_EXCEPTIONS_TABLE))), /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarSection, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 11
    }
  }, sort && /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarAction, {
    dataTestSubj: "sortExceptions",
    iconSide: "right",
    iconType: sort.order === 'asc' ? 'sortUp' : 'sortDown',
    popoverPanelPaddingSize: 's',
    popoverContent: () => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
      size: "s",
      items: sortFields === null || sortFields === void 0 ? void 0 : sortFields.map(item => {
        const isSelectedSortItem = (selectedSortField === null || selectedSortField === void 0 ? void 0 : selectedSortField.field) === item.field;
        let nextSortOrder = item.defaultOrder;
        if (isSelectedSortItem) {
          nextSortOrder = sort.order === 'asc' ? 'desc' : 'asc';
        }
        return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
          key: item.field,
          onClick: () => setSort === null || setSort === void 0 ? void 0 : setSort({
            field: item.field,
            order: nextSortOrder
          }),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 77,
            columnNumber: 25
          }
        }, /*#__PURE__*/_react.default.createElement(SortMenuItem, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 86,
            columnNumber: 27
          }
        }, item.label, ' ', (selectedSortField === null || selectedSortField === void 0 ? void 0 : selectedSortField.field) === item.field && /*#__PURE__*/_react.default.createElement(SortIcon, {
          type: sort.order === 'asc' ? 'sortUp' : 'sortDown',
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 89,
            columnNumber: 31
          }
        })));
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 19
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(SortMenuItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 17
    }
  }, i18n.SORT_BY, ' ', sortFields === null || sortFields === void 0 ? void 0 : (_sortFields$find = sortFields.find(sortField => sortField.field === sort.field)) === null || _sortFields$find === void 0 ? void 0 : _sortFields$find.label))))));
};
exports.ExceptionsTableUtilityBar = ExceptionsTableUtilityBar;
const SortMenuItem = (0, _styledComponents.default)('div')`
  display: flex;
  align-items: center;
`;
const SortIcon = (0, _styledComponents.default)(_eui.EuiIcon)`
  margin-left: 8px;
`;
ExceptionsTableUtilityBar.displayName = 'ExceptionsTableUtilityBar';