"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TopRiskScoreContributorsAlerts = void 0;
var _react = _interopRequireWildcard(require("react"));
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _eui = require("@elastic/eui");
var _use_group_take_action_items = require("../../../detections/hooks/alerts_table/use_group_take_action_items");
var _grouping_settings = require("../../../detections/components/alerts_table/grouping_settings");
var _header_section = require("../../../common/components/header_section");
var i18n = _interopRequireWildcard(require("./translations"));
var _search_strategy = require("../../../../common/search_strategy");
var _alerts_table = require("../../../detections/components/alerts_table");
var _alerts_grouping = require("../../../detections/components/alerts_table/alerts_grouping");
var _use_global_time = require("../../../common/containers/use_global_time");
var _use_selector = require("../../../common/hooks/use_selector");
var _inputs = require("../../../common/store/inputs");
var _user_info = require("../../../detections/components/user_info");
var _containers = require("../../../sourcerer/containers");
var _model = require("../../../sourcerer/store/model");
var _risk_information = require("../risk_information");
var _use_data_view = require("../../../data_view_manager/hooks/use_data_view");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/top_risk_score_contributors_alerts/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TopRiskScoreContributorsAlerts = ({
  toggleStatus,
  toggleQuery,
  riskScore,
  riskEntity,
  loading
}) => {
  const {
    to,
    from
  } = (0, _use_global_time.useGlobalTime)();
  const [{
    loading: userInfoLoading,
    hasIndexWrite,
    hasIndexMaintenance
  }] = (0, _user_info.useUserData)();
  const {
    sourcererDataView: oldSourcererDataViewSpec
  } = (0, _containers.useSourcererDataView)(_model.SourcererScopeName.detections);
  const {
    dataView: experimentalDataView
  } = (0, _use_data_view.useDataView)(_model.SourcererScopeName.detections);
  const getGlobalFiltersQuerySelector = (0, _react.useMemo)(() => _inputs.inputsSelectors.globalFiltersQuerySelector(), []);
  const getGlobalQuerySelector = (0, _react.useMemo)(() => _inputs.inputsSelectors.globalQuerySelector(), []);
  const query = (0, _use_selector.useDeepEqualSelector)(getGlobalQuerySelector);
  const filters = (0, _use_selector.useDeepEqualSelector)(getGlobalFiltersQuerySelector);
  const inputFilters = (0, _react.useMemo)(() => {
    var _riskScoreEntity$risk, _riskScoreEntity$risk2;
    // TODO Add support for services on a follow-up PR
    const riskScoreEntity = riskEntity === _search_strategy.EntityType.host ? riskScore.host : riskScore.user;
    const riskInputs = (_riskScoreEntity$risk = riskScoreEntity === null || riskScoreEntity === void 0 ? void 0 : (_riskScoreEntity$risk2 = riskScoreEntity.risk) === null || _riskScoreEntity$risk2 === void 0 ? void 0 : _riskScoreEntity$risk2.inputs) !== null && _riskScoreEntity$risk !== void 0 ? _riskScoreEntity$risk : [];
    return [{
      meta: {
        alias: null,
        negate: false,
        disabled: false
      },
      query: {
        terms: {
          _id: riskInputs.map(item => item.id)
        }
      }
    }];
  }, [riskScore, riskEntity]);
  const renderGroupedAlertTable = (0, _react.useCallback)(groupingFilters => {
    return /*#__PURE__*/_react.default.createElement(_alerts_table.AlertsTable, {
      tableType: _securitysolutionDataTable.TableId.alertsRiskInputs,
      inputFilters: [...inputFilters, ...filters, ...groupingFilters],
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 9
      }
    });
  }, [inputFilters, filters]);
  const defaultFilters = (0, _react.useMemo)(() => [...inputFilters, ...filters], [filters, inputFilters]);
  const groupTakeActionItems = (0, _use_group_take_action_items.useGroupTakeActionsItems)({
    showAlertStatusActions: Boolean(hasIndexWrite) && Boolean(hasIndexMaintenance)
  });
  const accordionExtraActionGroupStats = (0, _react.useMemo)(() => ({
    aggregations: _grouping_settings.defaultGroupStatsAggregations,
    renderer: _grouping_settings.defaultGroupStatsRenderer
  }), []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    "data-test-subj": "topRiskScoreContributorsAlerts",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: 'none',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
    title: i18n.TOP_RISK_SCORE_CONTRIBUTORS,
    hideSubtitle: true,
    toggleQuery: toggleQuery,
    toggleStatus: toggleStatus,
    headerFilters: /*#__PURE__*/_react.default.createElement(_risk_information.RiskInformationButtonEmpty, {
      riskEntity: riskEntity,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 131,
        columnNumber: 28
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 11
    }
  }))), toggleStatus && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "topRiskScoreContributorsAlerts-table",
    gutterSize: "none",
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_alerts_grouping.GroupedAlertsTable, {
    accordionButtonContent: _grouping_settings.defaultGroupTitleRenderers,
    accordionExtraActionGroupStats: accordionExtraActionGroupStats,
    dataViewSpec: oldSourcererDataViewSpec // TODO: Should be removed after migrating to new data view picker
    ,
    dataView: experimentalDataView,
    defaultFilters: defaultFilters,
    defaultGroupingOptions: _grouping_settings.defaultGroupingOptions,
    from: from,
    globalFilters: filters,
    globalQuery: query,
    groupTakeActionItems: groupTakeActionItems,
    loading: userInfoLoading || loading,
    renderChildComponent: renderGroupedAlertTable,
    tableId: _securitysolutionDataTable.TableId.alertsRiskInputs,
    to: to,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 13
    }
  }))));
};
exports.TopRiskScoreContributorsAlerts = TopRiskScoreContributorsAlerts;