"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OverwriteField = void 0;
var _react = _interopRequireWildcard(require("react"));
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_response_actions/endpoint/overwrite_process_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const OverwriteFieldComponent = ({
  path,
  disabled,
  readDefaultValueOnForm
}) => {
  const CONFIG = (0, _react.useMemo)(() => {
    return {
      defaultValue: true,
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.responseActions.endpoint.overwriteFieldLabel",
        defaultMessage: "Use the alert's {pid} value to identify the process to terminate.",
        values: {
          // eslint-disable-next-line react/jsx-no-literals
          pid: /*#__PURE__*/_react.default.createElement("strong", {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 32,
              columnNumber: 18
            }
          }, "process.pid")
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 27,
          columnNumber: 9
        }
      }) // in order to add a <strong> tag to the label, we need to cast element to string
    };
  }, []);
  return /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    component: _components.ToggleField,
    euiFieldProps: {
      'data-test-subj': 'config-overwrite-toggle'
    },
    path: path,
    readDefaultValueOnForm: readDefaultValueOnForm,
    config: CONFIG,
    isDisabled: disabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 5
    }
  });
};
const OverwriteField = exports.OverwriteField = /*#__PURE__*/_react.default.memo(OverwriteFieldComponent);