"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddRulesPage = void 0;
var _react = _interopRequireDefault(require("react"));
var _helpers = require("../../../common/helpers");
var _types = require("../../../../app/types");
var _header_page = require("../../../../common/components/header_page");
var _page_wrapper = require("../../../../common/components/page_wrapper");
var _kibana = require("../../../../common/lib/kibana");
var _spy_routes = require("../../../../common/utils/route/spy_routes");
var _user_info = require("../../../../detections/components/user_info");
var _use_lists_config = require("../../../../detections/containers/detection_engine/lists/use_lists_config");
var i18n = _interopRequireWildcard(require("./translations"));
var _add_prebuilt_rules_table = require("../../components/rules_table/add_prebuilt_rules_table/add_prebuilt_rules_table");
var _add_prebuilt_rules_table_context = require("../../components/rules_table/add_prebuilt_rules_table/add_prebuilt_rules_table_context");
var _add_prebuilt_rules_header_buttons = require("../../components/rules_table/add_prebuilt_rules_table/add_prebuilt_rules_header_buttons");
var _common = require("../../../../../common");
var _need_admin_for_update_rules_callout = require("../../../rule_management/components/callouts/need_admin_for_update_rules_callout");
var _missing_privileges = require("../../../../common/components/missing_privileges");
var _link_to = require("../../../../common/components/link_to");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management_ui/pages/add_rules/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AddRulesPageComponent = () => {
  const {
    navigateToApp
  } = (0, _kibana.useKibana)().services.application;
  const [{
    isSignalIndexExists,
    isAuthenticated,
    hasEncryptionKey
  }] = (0, _user_info.useUserData)();
  const {
    needsConfiguration: needsListsConfiguration
  } = (0, _use_lists_config.useListsConfig)();
  if ((0, _helpers.redirectToDetections)(isSignalIndexExists, isAuthenticated, hasEncryptionKey, needsListsConfiguration)) {
    navigateToApp(_common.APP_UI_ID, {
      deepLinkId: _types.SecurityPageName.alerts,
      path: (0, _link_to.getDetectionEngineUrl)()
    });
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_need_admin_for_update_rules_callout.NeedAdminForUpdateRulesCallOut, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_missing_privileges.MissingPrivilegesCallOut, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_add_prebuilt_rules_table_context.AddPrebuiltRulesTableContextProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
    title: i18n.PAGE_TITLE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_add_prebuilt_rules_header_buttons.AddPrebuiltRulesHeaderButtons, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_add_prebuilt_rules_table.AddPrebuiltRulesTable, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
    pageName: _types.SecurityPageName.rulesAdd,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 7
    }
  }));
};
const AddRulesPage = exports.AddRulesPage = /*#__PURE__*/_react.default.memo(AddRulesPageComponent);
AddRulesPage.displayName = 'AddRulesPage';