"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleActionsForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _rule_actions_field = require("../../../../../../common/components/rule_actions_field");
var _transform_actions = require("../../../../../../../common/detection_engine/transform_actions");
var _shared_imports = require("../../../../../../shared_imports");
var _rule_management = require("../../../../../../../common/api/detection_engine/rule_management");
var _bulk_edit_form_wrapper = require("./bulk_edit_form_wrapper");
var _translations = require("../translations");
var _kibana = require("../../../../../../common/lib/kibana");
var _helpers = require("../../../../../common/helpers");
var _validate_rule_actions_field = require("../../../../../../common/containers/rule_actions/validate_rule_actions_field");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management_ui/components/rules_table/bulk_actions/forms/rule_actions_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CommonUseField = (0, _shared_imports.getUseField)({
  component: _shared_imports.Field
});
const getFormSchema = actionTypeRegistry => ({
  actions: {
    validations: [{
      // Debounced validator not explicitly necessary here as the `RuleActionsFormData` form doesn't exhibit the same
      // behavior as the `ActionsStepRule` form outlined in https://github.com/elastic/kibana/issues/142217, however
      // additional renders are prevented so using for consistency
      validator: (0, _validate_rule_actions_field.debouncedValidateRuleActionsField)(actionTypeRegistry)
    }]
  },
  overwrite: {
    type: _shared_imports.FIELD_TYPES.CHECKBOX,
    label: _translations.bulkAddRuleActions.OVERWRITE_LABEL
  }
});
const defaultFormData = {
  actions: [],
  overwrite: false
};
const RuleActionsFormComponent = ({
  rulesCount,
  onClose,
  onConfirm
}) => {
  const {
    services: {
      triggersActionsUi: {
        actionTypeRegistry
      }
    }
  } = (0, _kibana.useKibana)();
  const formSchema = (0, _react.useMemo)(() => getFormSchema(actionTypeRegistry), [actionTypeRegistry]);
  const {
    form
  } = (0, _shared_imports.useForm)({
    schema: formSchema,
    defaultValue: defaultFormData
  });
  const [{
    overwrite
  }] = (0, _shared_imports.useFormData)({
    form,
    watch: ['overwrite', 'throttle']
  });
  const handleSubmit = (0, _react.useCallback)(async () => {
    const {
      data,
      isValid
    } = await form.submit();
    if (!isValid) {
      return;
    }
    const {
      actions = [],
      overwrite: overwriteValue
    } = data;
    const editAction = overwriteValue ? _rule_management.BulkActionEditTypeEnum.set_rule_actions : _rule_management.BulkActionEditTypeEnum.add_rule_actions;
    onConfirm({
      type: editAction,
      value: {
        actions: actions.map(_transform_actions.transformAlertToNormalizedRuleAction)
      }
    });
  }, [form, onConfirm]);
  const messageVariables = (0, _react.useMemo)(() => (0, _helpers.getAllActionMessageParams)(), []);
  return /*#__PURE__*/_react.default.createElement(_bulk_edit_form_wrapper.BulkEditFormWrapper, {
    form: form,
    title: _translations.bulkAddRuleActions.FORM_TITLE,
    onClose: onClose,
    onSubmit: handleSubmit,
    flyoutSize: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "primary",
    "data-test-subj": "bulkEditRulesRuleActionInfo",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.edit.addRuleActions.infoCalloutTitle",
      defaultMessage: "Configure actions for {rulesCount, plural, one {# rule} other {# rules}} you\u2019ve selected",
      values: {
        rulesCount
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("ul", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("li", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 11
    }
  }, _translations.bulkAddRuleActions.RULE_VARIABLES_DETAIL))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "actions",
    component: _rule_actions_field.RuleActionsField,
    componentProps: {
      messageVariables,
      summaryMessageVariables: messageVariables
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(CommonUseField, {
    path: "overwrite",
    componentProps: {
      idAria: 'bulkEditRulesOverwriteRuleActions',
      'data-test-subj': 'bulkEditRulesOverwriteRuleActions'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 7
    }
  }), overwrite && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    "data-test-subj": "bulkEditRulesRuleActionsWarning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.edit.addRuleActions.warningCalloutMessage",
    defaultMessage: "You're about to overwrite rule actions for {rulesCount, plural, one {# selected rule} other {# selected rules}}. Click {saveButton} to apply changes.",
    values: {
      rulesCount,
      saveButton: /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 168,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.edit.addRuleActions.warningCalloutMessage.buttonLabel",
        defaultMessage: "Save",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 169,
          columnNumber: 21
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 13
    }
  }))));
};
const RuleActionsForm = exports.RuleActionsForm = /*#__PURE__*/_react.default.memo(RuleActionsFormComponent);
RuleActionsForm.displayName = 'RuleActionsForm';