"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddPrebuiltRulesHeaderButtons = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _useBoolean = _interopRequireDefault(require("react-use/lib/useBoolean"));
var _user_info = require("../../../../../detections/components/user_info");
var _add_prebuilt_rules_table_context = require("./add_prebuilt_rules_table_context");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management_ui/components/rules_table/add_prebuilt_rules_table/add_prebuilt_rules_header_buttons.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AddPrebuiltRulesHeaderButtons = () => {
  var _selectedRules$length;
  const {
    state: {
      selectedRules,
      isRefetching,
      isUpgradingSecurityPackages,
      isAnyRuleInstalling,
      hasRulesToInstall
    },
    actions: {
      installAllRules,
      installSelectedRules
    }
  } = (0, _add_prebuilt_rules_table_context.useAddPrebuiltRulesTableContext)();
  const [{
    loading: isUserDataLoading,
    canUserCRUD
  }] = (0, _user_info.useUserData)();
  const canUserEditRules = canUserCRUD && !isUserDataLoading;
  const numberOfSelectedRules = (_selectedRules$length = selectedRules.length) !== null && _selectedRules$length !== void 0 ? _selectedRules$length : 0;
  const shouldDisplayInstallSelectedRulesButton = numberOfSelectedRules > 0;
  const isRequestInProgress = isAnyRuleInstalling || isRefetching || isUpgradingSecurityPackages;
  const [isOverflowPopoverOpen, setOverflowPopover] = (0, _useBoolean.default)(false);
  const onOverflowButtonClick = () => {
    setOverflowPopover(!isOverflowPopoverOpen);
  };
  const closeOverflowPopover = (0, _react.useCallback)(() => {
    setOverflowPopover(false);
  }, [setOverflowPopover]);
  const enableOnClick = (0, _react.useCallback)(() => {
    installSelectedRules(true);
    closeOverflowPopover();
  }, [closeOverflowPopover, installSelectedRules]);
  const installOnClick = (0, _react.useCallback)(() => {
    installSelectedRules();
  }, [installSelectedRules]);
  const overflowItems = (0, _react.useMemo)(() => [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "copy",
    icon: 'play',
    onClick: enableOnClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 7
    }
  }, i18n.INSTALL_AND_ENABLE_BUTTON_LABEL)], [enableOnClick]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false,
    wrap: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 5
    }
  }, shouldDisplayInstallSelectedRulesButton ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: installOnClick,
    disabled: !canUserEditRules || isRequestInProgress,
    "data-test-subj": "installSelectedRulesButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 13
    }
  }, i18n.INSTALL_SELECTED_RULES(numberOfSelectedRules), isAnyRuleInstalling && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 39
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      display: "base",
      size: "m",
      iconType: "boxesVertical",
      "aria-label": i18n.INSTALL_RULES_OVERFLOW_BUTTON_ARIA_LABEL,
      onClick: onOverflowButtonClick,
      disabled: !canUserEditRules || isRequestInProgress,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 17
      }
    }),
    isOpen: isOverflowPopoverOpen,
    closePopover: closeOverflowPopover,
    panelPaddingSize: "s",
    anchorPosition: "downRight",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: overflowItems,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 15
    }
  })))) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    iconType: "plusInCircle",
    "data-test-subj": "installAllRulesButton",
    onClick: installAllRules,
    disabled: !canUserEditRules || !hasRulesToInstall || isRequestInProgress,
    "aria-label": i18n.INSTALL_ALL_ARIA_LABEL,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 9
    }
  }, i18n.INSTALL_ALL, isAnyRuleInstalling && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 35
    }
  }))));
};
exports.AddPrebuiltRulesHeaderButtons = AddPrebuiltRulesHeaderButtons;