"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleUpdateCallouts = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _types = require("../../../../app/types");
var _links = require("../../../../common/components/links");
var _kibana = require("../../../../common/lib/kibana");
var _use_prebuilt_rules_status = require("../../../rule_management/logic/prebuilt_rules/use_prebuilt_rules_status");
var _mini_callout = require("../mini_callout/mini_callout");
var _translations = require("../mini_callout/translations");
var _rules_table_toolbar = require("../rules_table/rules_table_toolbar");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management_ui/components/rule_update_callouts/rule_update_callouts.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RuleUpdateCallouts = ({
  shouldShowNewRulesCallout = false,
  shouldShowUpdateRulesCallout = false
}) => {
  var _prebuiltRulesStatus$, _prebuiltRulesStatus$2;
  const {
    data: prebuiltRulesStatus
  } = (0, _use_prebuilt_rules_status.usePrebuiltRulesStatus)();
  const rulesToInstallCount = (_prebuiltRulesStatus$ = prebuiltRulesStatus === null || prebuiltRulesStatus === void 0 ? void 0 : prebuiltRulesStatus.stats.num_prebuilt_rules_to_install) !== null && _prebuiltRulesStatus$ !== void 0 ? _prebuiltRulesStatus$ : 0;
  const rulesToUpgradeCount = (_prebuiltRulesStatus$2 = prebuiltRulesStatus === null || prebuiltRulesStatus === void 0 ? void 0 : prebuiltRulesStatus.stats.num_prebuilt_rules_to_upgrade) !== null && _prebuiltRulesStatus$2 !== void 0 ? _prebuiltRulesStatus$2 : 0;

  // Check against rulesInstalledCount since we don't want to show banners if we're showing the empty prompt
  const shouldDisplayNewRulesCallout = shouldShowNewRulesCallout && rulesToInstallCount > 0;
  const shouldDisplayUpdateRulesCallout = shouldShowUpdateRulesCallout && rulesToUpgradeCount > 0;
  const getSecuritySolutionLinkProps = (0, _links.useGetSecuritySolutionLinkProps)();
  const {
    href
  } = getSecuritySolutionLinkProps({
    deepLinkId: _types.SecurityPageName.rules,
    path: _rules_table_toolbar.AllRulesTabs.updates
  });
  const {
    application: {
      navigateToUrl
    }
  } = (0, _kibana.useKibana)().services;
  const updateCallOutOnClick = (0, _react.useCallback)(() => {
    navigateToUrl(href);
  }, [navigateToUrl, href]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 5
    }
  }, shouldDisplayUpdateRulesCallout && /*#__PURE__*/_react.default.createElement(_mini_callout.MiniCallout, {
    iconType: 'info',
    "data-test-subj": "prebuilt-rules-update-callout",
    title: (0, _translations.getUpdateRulesCalloutTitle)(updateCallOutOnClick),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 9
    }
  }), shouldDisplayNewRulesCallout && /*#__PURE__*/_react.default.createElement(_mini_callout.MiniCallout, {
    color: "success",
    "data-test-subj": "prebuilt-rules-new-callout",
    iconType: 'info',
    title: _translations.NEW_PREBUILT_RULES_AVAILABLE_CALLOUT_TITLE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 9
    }
  }));
};
exports.RuleUpdateCallouts = RuleUpdateCallouts;