"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EqlQueryEditForm = EqlQueryEditForm;
var _react = _interopRequireDefault(require("react"));
var _field_final_side = require("../../../field_final_side");
var _detection_engine = require("../../../../../../../../../common/api/detection_engine");
var _eql_query_edit_adapter = require("./eql_query_edit_adapter");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management/components/rule_details/three_way_diff/final_edit/fields/eql_query/eql_query_edit_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function EqlQueryEditForm() {
  return /*#__PURE__*/_react.default.createElement(_field_final_side.RuleFieldEditFormWrapper, {
    component: _eql_query_edit_adapter.EqlQueryEditAdapter,
    ruleFieldFormSchema: kqlQuerySchema,
    deserializer: deserializer,
    serializer: serializer,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 23,
      columnNumber: 5
    }
  });
}
const kqlQuerySchema = {};
function deserializer(fieldValue, finalDiffableRule) {
  const parsedEqlQuery = 'eql_query' in finalDiffableRule ? _detection_engine.RuleEqlQuery.parse(fieldValue.eql_query) : {
    query: '',
    language: _detection_engine.QueryLanguageEnum.eql,
    filters: []
  };
  return {
    eqlQuery: {
      query: {
        query: parsedEqlQuery.query,
        language: parsedEqlQuery.language
      },
      // cast to Filter since RuleEqlQuery checks it's an array
      // potentially it might be incompatible type
      filters: parsedEqlQuery.filters,
      saved_id: null
    },
    eqlOptions: {
      eventCategoryField: parsedEqlQuery.event_category_override,
      timestampField: parsedEqlQuery.timestamp_field,
      tiebreakerField: parsedEqlQuery.tiebreaker_field
    }
  };
}
function serializer(formData) {
  const formValue = formData;
  return {
    eql_query: {
      query: formValue.eqlQuery.query.query,
      language: _detection_engine.QueryLanguageEnum.eql,
      filters: formValue.eqlQuery.filters,
      event_category_override: formValue.eqlOptions.eventCategoryField,
      timestamp_field: formValue.eqlOptions.timestampField,
      tiebreaker_field: formValue.eqlOptions.tiebreakerField
    }
  };
}