"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleDetailsFlyout = RuleDetailsFlyout;
exports.TabContentPadding = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _sharedUxErrorBoundary = require("@kbn/shared-ux-error-boundary");
var _rule_overview_tab = require("./rule_overview_tab");
var _rule_investigation_guide_tab = require("./rule_investigation_guide_tab");
var _constants = require("./constants");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management/components/rule_details/rule_details_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StyledEuiFlyoutBody = (0, _styledComponents.default)(_eui.EuiFlyoutBody)`
  .euiFlyoutBody__overflow {
    display: flex;
    flex: 1;
    overflow: hidden;
    /*
      Removes "transform: translateZ(0)" from EuiFlyoutBody styles to avoid creating a new stacking context.
      Fixed elements inside the flyout body are now correctly positioned relative to the viewport.
      See: https://github.com/elastic/eui/blob/ffd0cbca4d323ad0b1d5a73c252380d93178e5e7/packages/eui/src/global_styling/mixins/_helpers.ts#L122
      The Chrome bug mentioned in the link above no longer reproduces, so this change is safe.
    */
    transform: none;

    .euiFlyoutBody__overflowContent {
      flex: 1;
      overflow: hidden;
      padding: ${({
  theme
}) => `0 ${theme.eui.euiSizeL} 0`};
    }
  }
`;
const StyledFlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  height: 100%;
`;
const StyledEuiFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  &.euiFlexItem {
    flex: 1 0 0;
    overflow: hidden;
  }
`;
const StyledEuiTabbedContent = (0, _styledComponents.default)(_eui.EuiTabbedContent)`
  display: flex;
  flex: 1;
  flex-direction: column;
  overflow: hidden;

  > [role='tabpanel'] {
    display: flex;
    flex: 1;
    flex-direction: column;
    overflow: hidden;
    overflow-y: auto;

    ::-webkit-scrollbar {
      -webkit-appearance: none;
      width: 7px;
    }

    ::-webkit-scrollbar-thumb {
      border-radius: 4px;
      background-color: rgba(0, 0, 0, 0.5);
      -webkit-box-shadow: 0 0 1px rgba(255, 255, 255, 0.5);
    }
  }
`;

/*
 * Fixes tabs to the top and allows the content to scroll.
 */
const ScrollableFlyoutTabbedContent = props => /*#__PURE__*/_react.default.createElement(StyledFlexGroup, {
  direction: "column",
  gutterSize: "none",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 101,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(StyledEuiFlexItem, {
  grow: true,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 102,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(StyledEuiTabbedContent, (0, _extends2.default)({}, props, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 103,
    columnNumber: 7
  }
}))));
const TabContentPadding = ({
  children
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
        padding: 0 ${euiTheme.size.m} ${euiTheme.size.xl} ${euiTheme.size.m};
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 5
    }
  }, children);
};
exports.TabContentPadding = TabContentPadding;
function RuleDetailsFlyout({
  id,
  dataTestSubj,
  ...props
}) {
  const prebuiltRulesFlyoutTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'prebuiltRulesFlyoutTitle'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    id: id,
    size: props.size,
    onClose: props.closeFlyout,
    key: "prebuilt-rules-flyout",
    paddingSize: "l",
    "data-test-subj": dataTestSubj,
    "aria-labelledby": prebuiltRulesFlyoutTitleId,
    ownFocus: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxErrorBoundary.KibanaSectionErrorBoundary, {
    sectionName: i18n.RULE_DETAILS_FLYOUT_LABEL,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(RuleDetailsFlyoutContent, (0, _extends2.default)({}, props, {
    titleId: prebuiltRulesFlyoutTitleId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 9
    }
  }))));
}
const DEFAULT_EXTRA_TABS = [];
function RuleDetailsFlyoutContent({
  rule,
  ruleActions,
  subHeader,
  size = 'm',
  extraTabs = DEFAULT_EXTRA_TABS,
  titleId,
  closeFlyout,
  title
}) {
  var _tabs$find;
  const {
    expandedOverviewSections,
    toggleOverviewSection
  } = (0, _rule_overview_tab.useOverviewTabSections)();
  const overviewTab = (0, _react.useMemo)(() => ({
    id: 'overview',
    name: i18n.OVERVIEW_TAB_LABEL,
    content: /*#__PURE__*/_react.default.createElement(TabContentPadding, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 184,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_rule_overview_tab.RuleOverviewTab, {
      rule: rule,
      columnWidths: size === 'l' ? _constants.LARGE_DESCRIPTION_LIST_COLUMN_WIDTHS : _constants.DEFAULT_DESCRIPTION_LIST_COLUMN_WIDTHS,
      expandedOverviewSections: expandedOverviewSections,
      toggleOverviewSection: toggleOverviewSection,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 185,
        columnNumber: 11
      }
    }))
  }), [rule, size, expandedOverviewSections, toggleOverviewSection]);
  const investigationGuideTab = (0, _react.useMemo)(() => {
    var _rule$note;
    return {
      id: 'investigationGuide',
      name: i18n.INVESTIGATION_GUIDE_TAB_LABEL,
      content: /*#__PURE__*/_react.default.createElement(TabContentPadding, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 206,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_rule_investigation_guide_tab.RuleInvestigationGuideTab, {
        note: (_rule$note = rule.note) !== null && _rule$note !== void 0 ? _rule$note : '',
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 207,
          columnNumber: 11
        }
      }))
    };
  }, [rule.note]);
  const tabs = (0, _react.useMemo)(() => {
    if (rule.note) {
      return [...extraTabs, overviewTab, investigationGuideTab];
    } else {
      return [...extraTabs, overviewTab];
    }
  }, [overviewTab, investigationGuideTab, rule.note, extraTabs]);
  const [selectedTabId, setSelectedTabId] = (0, _react.useState)(tabs[0].id);
  const selectedTab = (_tabs$find = tabs.find(tab => tab.id === selectedTabId)) !== null && _tabs$find !== void 0 ? _tabs$find : tabs[0];
  (0, _react.useEffect)(() => {
    if (!tabs.find(tab => tab.id === selectedTabId)) {
      // Switch to first tab if currently selected tab is not available for this rule
      setSelectedTabId(tabs[0].id);
    }
  }, [tabs, selectedTabId]);
  const onTabClick = tab => {
    setSelectedTabId(tab.id);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 239,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: titleId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 11
    }
  }, title !== null && title !== void 0 ? title : rule.name)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 242,
      columnNumber: 9
    }
  }), subHeader && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, subHeader, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 246,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(StyledEuiFlyoutBody, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 250,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(ScrollableFlyoutTabbedContent, {
    tabs: tabs,
    selectedTab: selectedTab,
    onTabClick: onTabClick,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 257,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 258,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 259,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: closeFlyout,
    flush: "left",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 260,
      columnNumber: 13
    }
  }, i18n.DISMISS_BUTTON_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 264,
      columnNumber: 11
    }
  }, ruleActions))));
}