"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RiskScoreOverride = RiskScoreOverride;
var _react = _interopRequireWildcard(require("react"));
var _fp = require("lodash/fp");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _securitysolutionAutocomplete = require("@kbn/securitysolution-autocomplete");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_creation_ui/components/risk_score_mapping/risk_score_override.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const NestedContent = _styledComponents.default.div`
  margin-left: 24px;
`;
const EuiFlexItemComboBoxColumn = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  max-width: 376px;
`;
const EuiFlexItemIconColumn = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  width: 20px;
`;
const EuiFlexItemRiskScoreColumn = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  width: 160px;
`;
const fieldTypeFilter = ['number'];
function RiskScoreOverride({
  isMappingChecked,
  onToggleMappingChecked,
  onMappingChange,
  mapping,
  indices,
  dataTestSubj = 'riskScoreOverride',
  idAria,
  isDisabled
}) {
  const riskScoreMappingLabel = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement("div", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 67,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      onClick: !isDisabled ? onToggleMappingChecked : _fp.noop,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
      id: "risk_score-mapping-override",
      checked: isMappingChecked,
      onChange: onToggleMappingChecked,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 11
      }
    }, i18n.RISK_SCORE_MAPPING)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(NestedContent, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 11
      }
    }, i18n.RISK_SCORE_MAPPING_DESCRIPTION)));
  }, [isDisabled, isMappingChecked, onToggleMappingChecked]);
  const describedByIds = (0, _react.useMemo)(() => idAria ? [idAria] : undefined, [idAria]);
  const selectedField = (0, _react.useMemo)(() => getFieldTypeByMapping(mapping, indices), [mapping, indices]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: riskScoreMappingLabel,
    helpText: isMappingChecked ? /*#__PURE__*/_react.default.createElement(NestedContent, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 28
      }
    }, i18n.RISK_SCORE_MAPPING_DETAILS) : '',
    fullWidth: true,
    "data-test-subj": `${dataTestSubj}-riskOverride`,
    describedByIds: describedByIds,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(NestedContent, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 9
    }
  }), isMappingChecked && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(EuiFlexItemComboBoxColumn, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 19
    }
  }, i18n.SOURCE_FIELD)), /*#__PURE__*/_react.default.createElement(EuiFlexItemIconColumn, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(EuiFlexItemRiskScoreColumn, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 19
    }
  }, i18n.DEFAULT_RISK_SCORE)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(EuiFlexItemComboBoxColumn, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_securitysolutionAutocomplete.EsFieldSelector, {
    placeholder: "",
    indexPattern: indices,
    selectedField: selectedField,
    fieldTypeFilter: fieldTypeFilter,
    isDisabled: isDisabled,
    onChange: onMappingChange,
    "data-test-subj": dataTestSubj,
    "aria-label": idAria,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(EuiFlexItemIconColumn, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "sortRight",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(EuiFlexItemRiskScoreColumn, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 19
    }
  }, i18n.RISK_SCORE_FIELD)))))));
}

/**
 * Looks for field metadata (DataViewFieldBase) in existing index pattern.
 * If specified field doesn't exist, returns a stub DataViewFieldBase created based on the mapping --
 * because the field might not have been indexed yet, but we still need to display the mapping.
 *
 * @param mapping Mapping of a specified field name to risk score.
 * @param pattern Existing index pattern.
 */
const getFieldTypeByMapping = (mapping, pattern) => {
  var _mapping$0$field, _mapping$;
  const field = (_mapping$0$field = mapping === null || mapping === void 0 ? void 0 : (_mapping$ = mapping[0]) === null || _mapping$ === void 0 ? void 0 : _mapping$.field) !== null && _mapping$0$field !== void 0 ? _mapping$0$field : '';
  const [knownFieldType] = pattern.fields.filter(({
    name
  }) => field != null && field === name);
  return knownFieldType !== null && knownFieldType !== void 0 ? knownFieldType : {
    name: field,
    type: 'number'
  };
};