"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EqlQueryBar = void 0;
var _react = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _react2 = require("@emotion/react");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/data-plugin/public");
var _filter_bar = require("../../../../common/components/filter_bar");
var _use_app_toasts = require("../../../../common/hooks/use_app_toasts");
var _kibana = require("../../../../common/lib/kibana");
var _api = require("../../../../common/hooks/eql/api");
var _footer = require("./footer");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_creation/components/eql_query_edit/eql_query_bar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EqlQueryBar = ({
  dataTestSubj,
  field,
  eqlOptionsField,
  isLoading = false,
  indexPattern,
  showFilterBar,
  idAria,
  isSizeOptionDisabled,
  onValidityChange,
  onValidatingChange
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const {
    uiSettings
  } = (0, _kibana.useKibana)().services;
  const filterManager = (0, _react.useRef)(new _public.FilterManager(uiSettings));
  const {
    isValidating,
    value: fieldValue,
    setValue: setFieldValue,
    isValid,
    errors
  } = field;
  const errorMessages = (0, _react.useMemo)(() => errors.map(x => x.message), [errors]);
  const textAreaStyles = (0, _react.useMemo)(() => (0, _react2.css)`
      border-bottom-left-radius: 0;
      border-bottom-right-radius: 0;
      min-height: ${euiTheme.size.xl};
    `, [euiTheme.size.xl]);

  // Bubbles up field validity to parent.
  // Using something like form `getErrors` does
  // not guarantee latest validity state
  (0, _react.useEffect)(() => {
    if (onValidityChange != null) {
      onValidityChange(isValid);
    }
  }, [isValid, onValidityChange]);
  (0, _react.useEffect)(() => {
    const requestError = errors.find(x => x.code === _api.EQL_ERROR_CODES.FAILED_REQUEST);
    if (requestError) {
      addError(requestError.message, {
        title: i18n.EQL_VALIDATION_REQUEST_ERROR
      });
    }
  }, [errors, addError]);
  (0, _react.useEffect)(() => {
    if (onValidatingChange) {
      onValidatingChange(isValidating);
    }
  }, [isValidating, onValidatingChange]);
  (0, _react.useEffect)(() => {
    let isSubscribed = true;
    const subscriptions = new _rxjs.Subscription();
    filterManager.current.setFilters([]);
    subscriptions.add(filterManager.current.getUpdates$().subscribe({
      next: () => {
        if (isSubscribed) {
          const newFilters = filterManager.current.getFilters();
          const {
            filters
          } = fieldValue;
          if (!(0, _fastDeepEqual.default)(filters, newFilters)) {
            setFieldValue({
              ...fieldValue,
              filters: newFilters
            });
          }
        }
      }
    }));
    return () => {
      isSubscribed = false;
      subscriptions.unsubscribe();
    };
  }, [fieldValue, filterManager, setFieldValue]);
  (0, _react.useEffect)(() => {
    const {
      filters
    } = fieldValue;
    if (!(0, _fastDeepEqual.default)(filters, filterManager.current.getFilters())) {
      filterManager.current.setFilters(filters);
    }
  }, [fieldValue, filterManager]);
  const handleChange = (0, _react.useCallback)(e => {
    const newQuery = e.target.value;
    if (onValidatingChange) {
      onValidatingChange(true);
    }
    setFieldValue({
      filters: fieldValue.filters,
      query: {
        query: newQuery,
        language: 'eql'
      },
      saved_id: null
    });
  }, [fieldValue, setFieldValue, onValidatingChange]);
  const handleEqlOptionsChange = (0, _react.useCallback)((eqlOptionsFieldName, value) => {
    eqlOptionsField === null || eqlOptionsField === void 0 ? void 0 : eqlOptionsField.setValue(prevEqlOptions => ({
      ...prevEqlOptions,
      [eqlOptionsFieldName]: value
    }));
  }, [eqlOptionsField]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: field.label,
    labelAppend: field.labelAppend,
    helpText: field.helpText,
    error: errorMessages[0],
    isInvalid: !isValid && !isValidating,
    fullWidth: true,
    "data-test-subj": dataTestSubj,
    describedByIds: idAria ? [idAria] : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    "data-test-subj": "eqlQueryBarTextInput",
    css: textAreaStyles,
    fullWidth: true,
    isInvalid: !isValid && !isValidating,
    value: fieldValue.query.query,
    onChange: handleChange,
    "aria-label": field.label,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_footer.EqlQueryBarFooter, {
    errors: errorMessages,
    isLoading: isValidating,
    isSizeOptionDisabled: isSizeOptionDisabled,
    dataView: indexPattern,
    eqlOptions: eqlOptionsField === null || eqlOptionsField === void 0 ? void 0 : eqlOptionsField.value,
    onEqlOptionsChange: handleEqlOptionsChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 9
    }
  }), showFilterBar && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_filter_bar.FilterBar, {
    "data-test-subj": "eqlFilterBar",
    indexPattern: indexPattern,
    isLoading: isLoading,
    isRefreshPaused: false,
    filterQuery: fieldValue.query,
    filterManager: filterManager.current,
    filters: filterManager.current.getFilters() || [],
    displayStyle: "inPage",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 13
    }
  }))));
};
exports.EqlQueryBar = EqlQueryBar;