"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useReplaceUrlParams = exports.useGetInitialUrlParamValue = exports.isDetectionsPages = exports.getQueryStringFromLocation = exports.getParamFromQueryString = exports.getObjectFromQueryString = exports.encodeQueryString = exports.createHistoryEntry = void 0;
var _rison = require("@kbn/rison");
var _queryString = require("query-string");
var _public = require("@kbn/kibana-utils-plugin/public");
var _reactRouterDom = require("react-router-dom");
var _react = require("react");
var _types = require("../../../app/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isDetectionsPages = pageName => pageName === _types.SecurityPageName.alerts || pageName === _types.SecurityPageName.rules || pageName === _types.SecurityPageName.rulesAdd || pageName === _types.SecurityPageName.rulesCreate || pageName === _types.SecurityPageName.exceptions;
exports.isDetectionsPages = isDetectionsPages;
const getQueryStringFromLocation = search => search.substring(1);
exports.getQueryStringFromLocation = getQueryStringFromLocation;
const getParamFromQueryString = (queryString, key) => {
  const parsedQueryString = (0, _queryString.parse)(queryString, {
    sort: false
  });
  const queryParam = parsedQueryString[key];
  return Array.isArray(queryParam) ? queryParam[0] : queryParam;
};
exports.getParamFromQueryString = getParamFromQueryString;
const getObjectFromQueryString = (urlParamKey, search) => {
  const rawParamValue = getParamFromQueryString(getQueryStringFromLocation(search !== null && search !== void 0 ? search : window.location.search), urlParamKey);
  return (0, _rison.safeDecode)(rawParamValue !== null && rawParamValue !== void 0 ? rawParamValue : '');
};

/**
 *
 * Gets the value of the URL param from the query string.
 * It doesn't update when the URL changes.
 *
 */
exports.getObjectFromQueryString = getObjectFromQueryString;
const useGetInitialUrlParamValue = urlParamKey => {
  // window.location.search provides the most updated representation of the url search.
  // It also guarantees that we don't overwrite URL param managed outside react-router.
  const getInitialUrlParamValue = (0, _react.useCallback)(() => getObjectFromQueryString(urlParamKey), [urlParamKey]);
  return getInitialUrlParamValue;
};
exports.useGetInitialUrlParamValue = useGetInitialUrlParamValue;
const encodeQueryString = urlParams => (0, _queryString.stringify)(_public.url.encodeQuery(urlParams), {
  sort: false,
  encode: false
});
exports.encodeQueryString = encodeQueryString;
const useReplaceUrlParams = () => {
  const history = (0, _reactRouterDom.useHistory)();
  const replaceUrlParams = (0, _react.useCallback)(params => {
    // window.location.search provides the most updated representation of the url search.
    // It prevents unnecessary re-renders which useLocation would create because 'replaceUrlParams' does update the location.
    // window.location.search also guarantees that we don't overwrite URL param managed outside react-router.
    const search = window.location.search;
    const urlParams = (0, _queryString.parse)(search, {
      sort: false
    });
    Object.keys(params).forEach(key => {
      const value = params[key];
      if (value == null || value === '') {
        delete urlParams[key];
        return;
      }
      try {
        urlParams[key] = (0, _rison.encode)(value);
      } catch {
        // eslint-disable-next-line no-console
        console.error('Unable to encode url param value');
      }
    });
    const newSearch = encodeQueryString(urlParams);
    if (getQueryStringFromLocation(search) !== newSearch) {
      history.replace({
        search: newSearch
      });
    }
  }, [history]);
  return replaceUrlParams;
};
exports.useReplaceUrlParams = useReplaceUrlParams;
const createHistoryEntry = () => {
  // NOTE: This is a workaround to make sure that new history entry is created as a result of the user action.
  // This is needed because of the way global url state is handled in the security app.
  // (it defaults to replace the url params instead of pushing new history entry)
  window.history.pushState({}, '', window.location.href);
};
exports.createHistoryEntry = createHistoryEntry;