"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTotalCountFromTables = getTotalCountFromTables;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getTotalCountFromTables(tables) {
  return Object.values(tables).reduce((acc, table) => {
    var _table$meta, _table$meta$statistic;
    if ((table === null || table === void 0 ? void 0 : (_table$meta = table.meta) === null || _table$meta === void 0 ? void 0 : (_table$meta$statistic = _table$meta.statistics) === null || _table$meta$statistic === void 0 ? void 0 : _table$meta$statistic.totalCount) != null) {
      return acc + table.meta.statistics.totalCount;
    }
    return acc;
  }, 0);
}