"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBulkAlertTagsItems = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _use_alerts_privileges = require("../../../../detections/containers/detection_engine/alerts/use_alerts_privileges");
var _alert_bulk_tags = require("./alert_bulk_tags");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_set_alert_tags = require("./use_set_alert_tags");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/toolbar/bulk_actions/use_bulk_alert_tags_items.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useBulkAlertTagsItems = ({
  refetch
}) => {
  const {
    hasIndexWrite
  } = (0, _use_alerts_privileges.useAlertsPrivileges)();
  const setAlertTags = (0, _use_set_alert_tags.useSetAlertTags)();
  const handleOnAlertTagsSubmit = (0, _react.useCallback)(async (tags, ids, onSuccess, setIsLoading) => {
    if (setAlertTags) {
      await setAlertTags(tags, ids, onSuccess, setIsLoading);
    }
  }, [setAlertTags]);
  const alertTagsItems = (0, _react.useMemo)(() => hasIndexWrite ? [{
    key: 'manage-alert-tags',
    'data-test-subj': 'alert-tags-context-menu-item',
    name: i18n.ALERT_TAGS_CONTEXT_MENU_ITEM_TITLE,
    panel: 1,
    label: i18n.ALERT_TAGS_CONTEXT_MENU_ITEM_TITLE,
    disableOnQuery: true
  }] : [], [hasIndexWrite]);
  const TitleContent = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 9
    }
  }, i18n.ALERT_TAGS_CONTEXT_MENU_ITEM_TITLE), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: i18n.ALERT_TAGS_CONTEXT_MENU_ITEM_TOOLTIP_INFO,
    position: "right",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 11
    }
  }))), []);
  const renderContent = (0, _react.useCallback)(({
    alertItems,
    refresh,
    setIsBulkActionsLoading,
    clearSelection,
    closePopoverMenu
  }) => /*#__PURE__*/_react.default.createElement(_alert_bulk_tags.BulkAlertTagsPanel, {
    alertItems: alertItems,
    refresh: refresh,
    refetchQuery: refetch,
    setIsLoading: setIsBulkActionsLoading,
    clearSelection: clearSelection,
    closePopoverMenu: closePopoverMenu,
    onSubmit: handleOnAlertTagsSubmit,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 7
    }
  }), [handleOnAlertTagsSubmit, refetch]);
  const alertTagsPanels = (0, _react.useMemo)(() => hasIndexWrite ? [{
    id: 1,
    title: TitleContent,
    'data-test-subj': 'alert-tags-context-menu-panel',
    renderContent
  }] : [], [TitleContent, hasIndexWrite, renderContent]);
  return (0, _react.useMemo)(() => {
    return {
      alertTagsItems,
      alertTagsPanels
    };
  }, [alertTagsItems, alertTagsPanels]);
};
exports.useBulkAlertTagsItems = useBulkAlertTagsItems;