"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBulkActionItems = void 0;
var _react = require("react");
var _types = require("../../../../../common/types");
var i18n = _interopRequireWildcard(require("./translations"));
var _update_alerts = require("./update_alerts");
var _use_app_toasts = require("../../../hooks/use_app_toasts");
var _use_start_transaction = require("../../../lib/apm/use_start_transaction");
var _constants = require("../../../lib/apm/constants");
var _use_alert_close_info_modal = require("../../../../detections/hooks/use_alert_close_info_modal");
var _use_bulk_alert_closing_reason_items = require("./use_bulk_alert_closing_reason_items");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useBulkActionItems = ({
  eventIds,
  currentStatus,
  query,
  setEventsLoading,
  showAlertStatusActions = true,
  setEventsDeleted,
  onUpdateSuccess,
  onUpdateFailure,
  customBulkActions
}) => {
  const {
    addSuccess,
    addError,
    addWarning
  } = (0, _use_app_toasts.useAppToasts)();
  const {
    startTransaction
  } = (0, _use_start_transaction.useStartTransaction)();
  const {
    promptAlertCloseConfirmation
  } = (0, _use_alert_close_info_modal.useAlertCloseInfoModal)();
  const onAlertStatusUpdateSuccess = (0, _react.useCallback)((updated, conflicts, newStatus) => {
    if (conflicts > 0) {
      // Partial failure
      addWarning({
        title: i18n.UPDATE_ALERT_STATUS_FAILED(conflicts),
        text: i18n.UPDATE_ALERT_STATUS_FAILED_DETAILED(updated, conflicts)
      });
    } else {
      let title;
      switch (newStatus) {
        case 'closed':
          title = i18n.CLOSED_ALERT_SUCCESS_TOAST(updated);
          break;
        case 'open':
          title = i18n.OPENED_ALERT_SUCCESS_TOAST(updated);
          break;
        case 'acknowledged':
          title = i18n.ACKNOWLEDGED_ALERT_SUCCESS_TOAST(updated);
      }
      addSuccess({
        title
      });
    }
    if (onUpdateSuccess) {
      onUpdateSuccess(updated, conflicts, newStatus);
    }
  }, [addSuccess, addWarning, onUpdateSuccess]);
  const onAlertStatusUpdateFailure = (0, _react.useCallback)((newStatus, error) => {
    let title;
    switch (newStatus) {
      case 'closed':
        title = i18n.CLOSED_ALERT_FAILED_TOAST;
        break;
      case 'open':
        title = i18n.OPENED_ALERT_FAILED_TOAST;
        break;
      case 'acknowledged':
        title = i18n.ACKNOWLEDGED_ALERT_FAILED_TOAST;
    }
    addError(error.message, {
      title
    });
    if (onUpdateFailure) {
      onUpdateFailure(newStatus, error);
    }
  }, [addError, onUpdateFailure]);
  const onClickUpdate = (0, _react.useCallback)(async (status, reason) => {
    if (status === 'closed' && !(await promptAlertCloseConfirmation({
      query,
      ids: eventIds
    }))) {
      return;
    }
    if (query) {
      startTransaction({
        name: _constants.APM_USER_INTERACTIONS.BULK_QUERY_STATUS_UPDATE
      });
    } else if (eventIds.length > 1) {
      startTransaction({
        name: _constants.APM_USER_INTERACTIONS.BULK_STATUS_UPDATE
      });
    } else {
      startTransaction({
        name: _constants.APM_USER_INTERACTIONS.STATUS_UPDATE
      });
    }
    try {
      var _response$updated, _response$version_con;
      setEventsLoading({
        eventIds,
        isLoading: true
      });
      const response = await (0, _update_alerts.updateAlertStatus)({
        status,
        query: query && JSON.parse(query),
        signalIds: eventIds,
        reason
      });

      // TODO: Only delete those that were successfully updated from updatedRules
      setEventsDeleted({
        eventIds,
        isDeleted: true
      });
      if (response.version_conflicts && eventIds.length === 1) {
        throw new Error(i18n.BULK_ACTION_FAILED_SINGLE_ALERT);
      }
      onAlertStatusUpdateSuccess((_response$updated = response.updated) !== null && _response$updated !== void 0 ? _response$updated : 0, (_response$version_con = response.version_conflicts) !== null && _response$version_con !== void 0 ? _response$version_con : 0, status);
    } catch (error) {
      onAlertStatusUpdateFailure(status, error);
    } finally {
      setEventsLoading({
        eventIds,
        isLoading: false
      });
    }
  }, [setEventsLoading, eventIds, query, setEventsDeleted, onAlertStatusUpdateSuccess, onAlertStatusUpdateFailure, startTransaction, promptAlertCloseConfirmation]);
  const {
    item: alertClosingReasonItem,
    panels: alertClosingReasonPanels
  } = (0, _use_bulk_alert_closing_reason_items.useBulkAlertClosingReasonItems)({
    onSubmitCloseReason({
      reason
    }) {
      onClickUpdate(_types.FILTER_CLOSED, reason);
    }
  });
  const items = (0, _react.useMemo)(() => {
    const actionItems = [];
    if (showAlertStatusActions) {
      if (currentStatus !== _types.FILTER_OPEN) {
        actionItems.push({
          key: 'open',
          'data-test-subj': 'open-alert-status',
          onClick: () => onClickUpdate(_types.FILTER_OPEN),
          name: i18n.BULK_ACTION_OPEN_SELECTED
        });
      }
      if (currentStatus !== _types.FILTER_ACKNOWLEDGED) {
        actionItems.push({
          key: 'acknowledge',
          'data-test-subj': 'acknowledged-alert-status',
          onClick: () => onClickUpdate(_types.FILTER_ACKNOWLEDGED),
          name: i18n.BULK_ACTION_ACKNOWLEDGED_SELECTED
        });
      }
      if (currentStatus !== _types.FILTER_CLOSED) {
        actionItems.push({
          key: alertClosingReasonItem === null || alertClosingReasonItem === void 0 ? void 0 : alertClosingReasonItem.key,
          'data-test-subj': alertClosingReasonItem === null || alertClosingReasonItem === void 0 ? void 0 : alertClosingReasonItem['data-test-subj'],
          name: alertClosingReasonItem === null || alertClosingReasonItem === void 0 ? void 0 : alertClosingReasonItem.label,
          panel: alertClosingReasonItem === null || alertClosingReasonItem === void 0 ? void 0 : alertClosingReasonItem.panel
        });
      }
    }
    const additionalItems = customBulkActions ? customBulkActions.reduce((acc, action) => {
      const isDisabled = !!(query && action.disableOnQuery);
      acc.push({
        key: action.key,
        disabled: isDisabled,
        'data-test-subj': action['data-test-subj'],
        toolTipContent: isDisabled ? action.disabledLabel : null,
        onClick: () => action.onClick(eventIds),
        name: action.label
      });
      return acc;
    }, []) : [];
    return [...actionItems, ...additionalItems];
  }, [alertClosingReasonItem, currentStatus, customBulkActions, eventIds, onClickUpdate, query, showAlertStatusActions]);
  const panels = (0, _react.useMemo)(() => [...alertClosingReasonPanels.map(panel => {
    return {
      ...panel,
      content: panel.renderContent({
        alertItems: [],
        closePopoverMenu: () => {},
        setIsBulkActionsLoading: () => {}
      })
    };
  })], [alertClosingReasonPanels]);
  return (0, _react.useMemo)(() => ({
    items,
    panels
  }), [items, panels]);
};
exports.useBulkActionItems = useBulkActionItems;