"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PanelText = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _css = require("@emotion/css");
var _eui = require("@elastic/eui");
var _reactKibanaContextTheme = require("@kbn/react-kibana-context-theme");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/panel_text/panel_text.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const PanelText = exports.PanelText = /*#__PURE__*/_react.default.memo(({
  children,
  subdued,
  semiBold,
  cursive,
  ...props
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const isDarkMode = (0, _reactKibanaContextTheme.useKibanaIsDarkMode)();
  let color;
  if (subdued && !isDarkMode) {
    color = 'subdued';
  }
  const style = {};
  if (semiBold) {
    style.fontWeight = euiTheme.font.weight.semiBold;
  }
  if (cursive) {
    style.fontStyle = 'italic';
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, (0, _extends2.default)({}, props, {
    color: color,
    className: (0, _css.css)(style),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 7
    }
  }), children);
});
PanelText.displayName = 'PanelText';