"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExitFullScreen = exports.EXIT_FULL_SCREEN_CLASS_NAME = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/exit_full_screen/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EXIT_FULL_SCREEN_CLASS_NAME = exports.EXIT_FULL_SCREEN_CLASS_NAME = 'exit-full-screen';
const ExitFullScreenComponent = ({
  fullScreen,
  setFullScreen
}) => {
  const exitFullScreen = (0, _react.useCallback)(() => {
    setFullScreen(false);
  }, [setFullScreen]);
  const onKeyDown = (0, _react.useCallback)(event => {
    if (event.key === 'Escape') {
      event.preventDefault();
      exitFullScreen();
    }
  }, [exitFullScreen]);
  if (!fullScreen) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiWindowEvent, {
    event: "keydown",
    handler: onKeyDown,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    className: EXIT_FULL_SCREEN_CLASS_NAME,
    "data-test-subj": "exit-full-screen",
    fullWidth: false,
    iconType: "fullScreen",
    fill: true,
    isDisabled: !fullScreen,
    onClick: exitFullScreen,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 7
    }
  }, i18n.EXIT_FULL_SCREEN));
};
ExitFullScreenComponent.displayName = 'ExitFullScreenComponent';
const ExitFullScreen = exports.ExitFullScreen = /*#__PURE__*/_react.default.memo(ExitFullScreenComponent);