"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostIsolationPanel = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _get_event_details_field_values = require("../../../../lib/endpoint/utils/get_event_details_field_values");
var _use_cases_from_alerts = require("../../../../../detections/containers/detection_engine/alerts/use_cases_from_alerts");
var _isolate = require("./isolate");
var _unisolate = require("./unisolate");
var _use_alert_response_actions_support = require("../../../../hooks/endpoint/use_alert_response_actions_support");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/endpoint/host_isolation/from_alerts/host_isolation_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const HostIsolationPanel = exports.HostIsolationPanel = /*#__PURE__*/_react.default.memo(({
  details,
  cancelCallback,
  successCallback,
  isolateAction
}) => {
  const {
    isSupported: alertHostSupportsResponseActions,
    details: {
      agentId,
      agentType,
      hostName
    }
  } = (0, _use_alert_response_actions_support.useAlertResponseActionsSupport)(details);
  const alertId = (0, _react.useMemo)(() => (0, _get_event_details_field_values.getAlertDetailsFieldValue)({
    category: '_id',
    field: '_id'
  }, details), [details]);
  const {
    casesInfo
  } = (0, _use_cases_from_alerts.useCasesFromAlerts)({
    alertId
  });
  const formProps = (0, _react.useMemo)(() => {
    return {
      endpointId: agentId,
      hostName,
      casesInfo,
      agentType,
      cancelCallback,
      successCallback
    };
  }, [agentId, agentType, cancelCallback, casesInfo, hostName, successCallback]);
  if (!alertHostSupportsResponseActions) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      color: "warning",
      "data-test-subj": "unsupportedAlertHost",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.detections.hostIsolation.alertHostNotSupported",
      defaultMessage: "The alert's host ({hostName}) does not support host isolation response actions.",
      values: {
        hostName
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 11
      }
    }));
  }
  return isolateAction === 'isolateHost' ? /*#__PURE__*/_react.default.createElement(_isolate.IsolateHost, (0, _extends2.default)({}, formProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 7
    }
  })) : /*#__PURE__*/_react.default.createElement(_unisolate.UnisolateHost, (0, _extends2.default)({}, formProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  }));
});
HostIsolationPanel.displayName = 'HostIsolationContent';