"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DragDropContextWrapperComponent = exports.DragDropContextWrapper = void 0;
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _dnd = require("@hello-pangea/dnd");
var _reactRedux = require("react-redux");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _securitysolutionTGrid = require("@kbn/securitysolution-t-grid");
var _store = require("../../store");
var _store2 = require("../../../timelines/store");
var _helpers = require("../../../timelines/components/timeline/data_providers/helpers");
var _translations = require("../../hooks/translations");
var _toasters = require("../toasters");
var _timeline = require("../../../../common/types/timeline");
var _timeline2 = require("../../../../common/api/timeline");
var _helpers2 = require("./helpers");
var _use_selector = require("../../hooks/use_selector");
var _kibana = require("../../lib/kibana");
var _defaults = require("../../../timelines/store/defaults");
var _default_alert_headers = require("../events_viewer/default_alert_headers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/drag_and_drop/drag_drop_context_wrapper.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// @ts-expect-error
window['__@hello-pangea/dnd-disable-dev-warnings'] = true;
const onDragEndHandler = ({
  activeTimelineDataProviders,
  browserFields,
  dataProviders,
  dispatch,
  onAddedToTimeline,
  result
}) => {
  if ((0, _helpers2.userIsReArrangingProviders)(result)) {
    (0, _helpers.reArrangeProviders)({
      dataProviders: activeTimelineDataProviders,
      destination: result.destination,
      dispatch,
      source: result.source,
      timelineId: _timeline.TimelineId.active
    });
  } else if ((0, _helpers2.providerWasDroppedOnTimeline)(result)) {
    (0, _helpers2.addProviderToTimeline)({
      activeTimelineDataProviders,
      dataProviders,
      dispatch,
      onAddedToTimeline,
      result,
      timelineId: _timeline.TimelineId.active
    });
  } else if ((0, _helpers2.fieldWasDroppedOnTimelineColumns)(result)) {
    var _result$destination$d, _result$destination;
    (0, _helpers2.addFieldToColumns)({
      browserFields,
      defaultsHeader: _default_alert_headers.defaultAlertsHeaders,
      dispatch,
      result,
      scopeId: (0, _helpers2.getIdFromColumnDroppableId)((_result$destination$d = (_result$destination = result.destination) === null || _result$destination === void 0 ? void 0 : _result$destination.droppableId) !== null && _result$destination$d !== void 0 ? _result$destination$d : '')
    });
  }
};

/**
 * DragDropContextWrapperComponent handles all drag end events
 */
const DragDropContextWrapperComponent = ({
  browserFields,
  children
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const getTimeline = (0, _react.useMemo)(() => _store2.timelineSelectors.getTimelineByIdSelector(), []);
  const getDataProviders = (0, _react.useMemo)(() => _store.dragAndDropSelectors.getDataProvidersSelector(), []);
  const {
    timelines
  } = (0, _kibana.useKibana)().services;
  const sensors = [timelines.getUseAddToTimelineSensor()];
  const {
    dataProviders: activeTimelineDataProviders,
    timelineType
  } = (0, _use_selector.useDeepEqualSelector)(state => {
    var _getTimeline;
    return (0, _fp.pick)(['dataProviders', 'timelineType'], (_getTimeline = getTimeline(state, _timeline.TimelineId.active)) !== null && _getTimeline !== void 0 ? _getTimeline : _defaults.timelineDefaults);
  });
  const dataProviders = (0, _use_selector.useDeepEqualSelector)(getDataProviders);
  const [, dispatchToaster] = (0, _toasters.useStateToaster)();
  const onAddedToTimeline = (0, _react.useCallback)(fieldOrValue => {
    const message = timelineType === _timeline2.TimelineTypeEnum.template ? (0, _translations.ADDED_TO_TIMELINE_TEMPLATE_MESSAGE)(fieldOrValue) : (0, _translations.ADDED_TO_TIMELINE_MESSAGE)(fieldOrValue);
    (0, _toasters.displaySuccessToast)(message, dispatchToaster);
  }, [dispatchToaster, timelineType]);
  const onDragEnd = (0, _react.useCallback)(result => {
    try {
      enableScrolling();
      if (dataProviders != null) {
        onDragEndHandler({
          activeTimelineDataProviders,
          browserFields,
          dataProviders,
          dispatch,
          onAddedToTimeline,
          result
        });
      }
    } finally {
      document.body.classList.remove(_securitysolutionTGrid.IS_DRAGGING_CLASS_NAME);
      if ((0, _helpers2.draggableIsField)(result)) {
        document.body.classList.remove(_helpers2.IS_TIMELINE_FIELD_DRAGGING_CLASS_NAME);
      }
    }
  }, [activeTimelineDataProviders, browserFields, dataProviders, dispatch, onAddedToTimeline]);
  return /*#__PURE__*/_react.default.createElement(_dnd.DragDropContext, {
    onBeforeDragStart: onBeforeDragStart,
    onDragEnd: onDragEnd,
    sensors: sensors,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 5
    }
  }, children);
};
exports.DragDropContextWrapperComponent = DragDropContextWrapperComponent;
DragDropContextWrapperComponent.displayName = 'DragDropContextWrapperComponent';
const DragDropContextWrapper = exports.DragDropContextWrapper = /*#__PURE__*/_react.default.memo(DragDropContextWrapperComponent,
// prevent re-renders when data providers are added or removed, but all other props are the same
(prevProps, nextProps) => (0, _fastDeepEqual.default)(prevProps.children, nextProps.children));
DragDropContextWrapper.displayName = 'DragDropContextWrapper';
const onBeforeDragStart = start => {
  if (!(0, _helpers2.draggableIsField)(start)) {
    document.body.classList.add(_securitysolutionTGrid.IS_DRAGGING_CLASS_NAME);
  }
  if ((0, _helpers2.draggableIsField)(start)) {
    document.body.classList.add(_helpers2.IS_TIMELINE_FIELD_DRAGGING_CLASS_NAME);
  }
};
const enableScrolling = () => window.onscroll = () => _fp.noop;