"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Generations = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _get_approximate_future_time = require("./get_approximate_future_time");
var _get_connector_name_from_id = require("../../../utils/get_connector_name_from_id");
var _loading_callout = require("../../../loading_callout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/attack_discovery/pages/results/history/generations/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const N_LATEST_NON_DISMISSED_GENERATIONS = 5; // show only the latest n non-dismissed generations

const GenerationsComponent = ({
  aiConnectors,
  data,
  localStorageAttackDiscoveryMaxAlerts,
  refetchGenerations
}) => {
  const callouts = (0, _react.useMemo)(() => {
    var _data$generations$fil;
    return (_data$generations$fil = data === null || data === void 0 ? void 0 : data.generations.filter(({
      status
    }) => status !== 'dismissed') // filter out dismissed generations
    .slice(0, N_LATEST_NON_DISMISSED_GENERATIONS) // limit display to a handful of the latest, non-dismissed generations
    .map(({
      alerts_context_count: alertsContextCount,
      discoveries,
      end: generationEndTime,
      connector_stats: connectorStats,
      connector_id: connectorId,
      execution_uuid: executionUuid,
      loading_message: loadingMessage,
      reason,
      start,
      status
    }, i) => /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "generations",
      key: executionUuid,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_loading_callout.LoadingCallout, {
      alertsContextCount: alertsContextCount !== null && alertsContextCount !== void 0 ? alertsContextCount : null,
      approximateFutureTime: (0, _get_approximate_future_time.getApproximateFutureTime)({
        averageSuccessfulDurationNanoseconds: connectorStats === null || connectorStats === void 0 ? void 0 : connectorStats.average_successful_duration_nanoseconds,
        generationStartTime: start
      }),
      averageSuccessfulDurationNanoseconds: connectorStats === null || connectorStats === void 0 ? void 0 : connectorStats.average_successful_duration_nanoseconds,
      connectorName: (0, _get_connector_name_from_id.getConnectorNameFromId)({
        aiConnectors,
        connectorId
      }),
      discoveries: discoveries,
      executionUuid: executionUuid,
      generationEndTime: generationEndTime,
      localStorageAttackDiscoveryMaxAlerts: localStorageAttackDiscoveryMaxAlerts,
      loadingMessage: loadingMessage,
      refetchGenerations: refetchGenerations,
      reason: reason,
      status: status,
      successfulGenerations: connectorStats === null || connectorStats === void 0 ? void 0 : connectorStats.successful_generations,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 15
      }
    }), i < (data === null || data === void 0 ? void 0 : data.generations.length) - 1 && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 52
      }
    })))) !== null && _data$generations$fil !== void 0 ? _data$generations$fil : null;
  }, [aiConnectors, data === null || data === void 0 ? void 0 : data.generations, localStorageAttackDiscoveryMaxAlerts, refetchGenerations]);
  return callouts;
};
GenerationsComponent.displayName = 'Generations';
const Generations = exports.Generations = /*#__PURE__*/_react.default.memo(GenerationsComponent);