"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssetInventoryOnboarding = void 0;
var _react = _interopRequireDefault(require("react"));
var _get_started = require("./get_started");
var _asset_inventory_loading = require("../asset_inventory_loading");
var _use_asset_inventory_status = require("../../hooks/use_asset_inventory_status");
var _initializing = require("./initializing");
var _no_data_found = require("./no_data_found");
var _permission_denied = require("./permission_denied");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/asset_inventory/components/onboarding/asset_inventory_onboarding.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * This component serves as a wrapper to render appropriate onboarding screens
 * based on the current onboarding status. If no specific onboarding status
 * matches, it will render the child components.
 */
const AssetInventoryOnboarding = ({
  children
}) => {
  const {
    data,
    isLoading
  } = (0, _use_asset_inventory_status.useAssetInventoryStatus)();
  if (isLoading || !data) {
    return /*#__PURE__*/_react.default.createElement(_asset_inventory_loading.AssetInventoryLoading, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 26,
        columnNumber: 12
      }
    });
  }
  const {
    status,
    privileges
  } = data;
  // Render different screens based on the onboarding status.
  switch (status) {
    case 'inactive_feature':
    case 'disabled':
      // The user has not yet started the onboarding process.
      return /*#__PURE__*/_react.default.createElement(_get_started.GetStarted, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 33,
          columnNumber: 14
        }
      });
    case 'initializing':
      // The onboarding process is currently initializing.
      return /*#__PURE__*/_react.default.createElement(_initializing.Initializing, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 35,
          columnNumber: 14
        }
      });
    case 'empty':
      // Onboarding cannot proceed because no relevant data was found.
      return /*#__PURE__*/_react.default.createElement(_no_data_found.NoDataFound, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 37,
          columnNumber: 14
        }
      });
    case 'insufficient_privileges':
      // User lacks the necessary permissions to proceed.
      return /*#__PURE__*/_react.default.createElement(_permission_denied.PermissionDenied, {
        privileges: privileges,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 39,
          columnNumber: 14
        }
      });
    default:
      // If no onboarding status matches, render the child components.
      return children;
  }
};
exports.AssetInventoryOnboarding = AssetInventoryOnboarding;