"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GlobalHeader = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _reactReversePortal = require("react-reverse-portal");
var _i18n = require("@kbn/i18n");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _constants = require("../../../data_view_manager/constants");
var _common = require("../../../../common");
var _use_experimental_features = require("../../../common/hooks/use_experimental_features");
var _ml_popover = require("../../../common/components/ml_popover/ml_popover");
var _kibana = require("../../../common/lib/kibana");
var _helpers = require("../../../helpers");
var _components = require("../../../sourcerer/components");
var _timeline = require("../../../../common/types/timeline");
var _defaults = require("../../../timelines/store/defaults");
var _store = require("../../../timelines/store");
var _use_selector = require("../../../common/hooks/use_selector");
var _sourcerer_paths = require("../../../sourcerer/containers/sourcerer_paths");
var _use_add_integrations_url = require("../../../common/hooks/use_add_integrations_url");
var _data_view_picker = require("../../../data_view_manager/components/data_view_picker");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/app/home/global_header/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const BUTTON_ADD_DATA = _i18n.i18n.translate('xpack.securitySolution.globalHeader.buttonAddData', {
  defaultMessage: 'Add integrations'
});

/**
 * This component uses the reverse portal to add the Add Data, ML job settings, and AI Assistant buttons on the
 * right hand side of the Kibana global header
 */
const GlobalHeader = exports.GlobalHeader = /*#__PURE__*/_react.default.memo(() => {
  var _capabilities$SECURIT;
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const portalNode = (0, _react.useMemo)(() => (0, _reactReversePortal.createHtmlPortalNode)(), []);
  const {
    theme,
    setHeaderActionMenu,
    i18n: kibanaServiceI18n,
    application: {
      capabilities
    }
  } = (0, _kibana.useKibana)().services;
  const hasSearchAILakeConfigurations = ((_capabilities$SECURIT = capabilities[_common.SECURITY_FEATURE_ID]) === null || _capabilities$SECURIT === void 0 ? void 0 : _capabilities$SECURIT.configurations) === true;
  const {
    pathname
  } = (0, _reactRouterDom.useLocation)();
  const getTimeline = (0, _react.useMemo)(() => _store.timelineSelectors.getTimelineByIdSelector(), []);
  const showTimeline = (0, _use_selector.useShallowEqualSelector)(state => {
    var _getTimeline;
    return ((_getTimeline = getTimeline(state, _timeline.TimelineId.active)) !== null && _getTimeline !== void 0 ? _getTimeline : _defaults.timelineDefaults).show;
  });
  const sourcererScope = (0, _sourcerer_paths.getScopeFromPath)(pathname, newDataViewPickerEnabled);
  const showSourcerer = (0, _sourcerer_paths.showSourcererByPath)(pathname);
  const dashboardViewPath = (0, _helpers.isDashboardViewPath)(pathname);
  const {
    href,
    onClick
  } = (0, _use_add_integrations_url.useAddIntegrationsUrl)();
  (0, _react.useEffect)(() => {
    if (setHeaderActionMenu) {
      setHeaderActionMenu(element => {
        const mount = (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_reactReversePortal.OutPortal, {
          node: portalNode,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 71,
            columnNumber: 36
          }
        }), {
          theme,
          i18n: kibanaServiceI18n
        });
        return mount(element);
      });
      return () => {
        /* Dashboard mounts an edit toolbar, it should be restored when leaving dashboard editing page */
        if (dashboardViewPath) {
          return;
        }
        portalNode.unmount();
        setHeaderActionMenu(undefined);
      };
    }
  }, [portalNode, setHeaderActionMenu, theme, kibanaServiceI18n, dashboardViewPath]);
  const dataViewPicker = newDataViewPickerEnabled ? /*#__PURE__*/_react.default.createElement(_data_view_picker.DataViewPicker, {
    scope: sourcererScope,
    disabled: sourcererScope === _constants.DataViewManagerScopeName.detections,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(_components.Sourcerer, {
    scope: sourcererScope,
    "data-test-subj": "sourcerer",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 5
    }
  });
  return /*#__PURE__*/_react.default.createElement(_reactReversePortal.InPortal, {
    node: portalNode,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderSection, {
    side: "right",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 7
    }
  }, (0, _helpers.isDetectionsPath)(pathname) && /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderSectionItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_ml_popover.MlPopover, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderSectionItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLinks, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 11
    }
  }, !hasSearchAILakeConfigurations && /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLink, {
    color: "primary",
    "data-test-subj": "add-data",
    href: href,
    iconType: "indexOpen",
    onClick: onClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 15
    }
  }, BUTTON_ADD_DATA), showSourcerer && !showTimeline && dataViewPicker))));
});
GlobalHeader.displayName = 'GlobalHeader';