"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PromptPage = PromptPage;
require("css.escape");
var _eui = require("@elastic/eui");
var _warning = require("@elastic/eui/lib/components/icon/assets/warning");
var _icon = require("@elastic/eui/lib/components/icon/icon");
var _cache = _interopRequireDefault(require("@emotion/cache"));
var _createInstance = _interopRequireDefault(require("@emotion/server/create-instance"));
var _react = _interopRequireDefault(require("react"));
var _server = require("react-dom/server");
var _coreRenderingServerInternal = require("@kbn/core-rendering-server-internal");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var UiSharedDepsSrc = _interopRequireWildcard(require("@kbn/ui-shared-deps-src"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/security/server/prompt_page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// Polyfill required to render `EuiPageTemplate` server-side
// @ts-expect-error no definitions in component folder
// @ts-expect-error no definitions in component folder
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// Preload the warning icon used by `EuiEmptyPrompt` to ensure that it's loaded
// in advance the first time this page is rendered server-side. If not, the
// icon svg wouldn't contain any paths the first time the page was rendered.
(0, _icon.appendIconComponentCache)({
  warning: _warning.icon
});
const emotionCache = (0, _cache.default)({
  key: 'eui',
  stylisPlugins: [_eui.euiStylisPrefixer]
});
function PromptPage({
  basePath,
  staticAssets,
  scriptPaths = [],
  title,
  body,
  actions,
  customBranding
}) {
  const content = /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiProvider, {
    colorMode: "light",
    cache: emotionCache,
    highContrastMode: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate, {
    "data-test-subj": "promptPage",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
    iconType: "warning",
    iconColor: "danger",
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 20
      }
    }, title),
    body: body,
    actions: actions,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 11
    }
  }))));
  const {
    extractCriticalToChunks,
    constructStyleTagsFromChunks
  } = (0, _createInstance.default)(emotionCache);
  const chunks = extractCriticalToChunks((0, _server.renderToString)(content));
  const emotionStyles = constructStyleTagsFromChunks(chunks);
  const uiPublicURL = staticAssets.prependPublicUrl('/ui');
  const regularBundlePath = staticAssets.prependPublicUrl('/bundles');
  const styleSheetPaths = [`${regularBundlePath}/kbn-ui-shared-deps-src/${UiSharedDepsSrc.cssDistFilename}`];
  return /*#__PURE__*/_react.default.createElement("html", {
    lang: _i18n.i18n.getLocale(),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("head", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("title", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 9
    }
  }, customBranding.pageTitle ? customBranding.pageTitle : 'Elastic'), /*#__PURE__*/_react.default.createElement("style", {
    dangerouslySetInnerHTML: {
      __html: `</style>${emotionStyles}`
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 9
    }
  }), styleSheetPaths.map(path => /*#__PURE__*/_react.default.createElement("link", {
    href: path,
    rel: "stylesheet",
    key: path,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_coreRenderingServerInternal.Fonts, {
    url: uiPublicURL,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 9
    }
  }), customBranding.faviconPNG ? /*#__PURE__*/_react.default.createElement("link", {
    rel: "alternate icon",
    type: "image/png",
    href: customBranding.faviconPNG,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement("link", {
    rel: "alternate icon",
    type: "image/png",
    href: `${uiPublicURL}/favicons/favicon.png`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 11
    }
  }), customBranding.faviconSVG ? /*#__PURE__*/_react.default.createElement("link", {
    rel: "icon",
    type: "image/svg+xml",
    href: customBranding.faviconSVG,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement("link", {
    rel: "icon",
    type: "image/svg+xml",
    href: `${uiPublicURL}/favicons/favicon.svg`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 11
    }
  }), scriptPaths.map(path => /*#__PURE__*/_react.default.createElement("script", {
    src: basePath.prepend(path),
    key: path,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement("meta", {
    name: "theme-color",
    content: "#ffffff",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement("meta", {
    name: "color-scheme",
    content: "light dark",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement("body", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 7
    }
  }, content));
}