"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "Actions", {
  enumerable: true,
  get: function () {
    return _securityAuthorizationCore.Actions;
  }
});
exports.AuthorizationService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _querystring = _interopRequireDefault(require("querystring"));
var _react = _interopRequireDefault(require("react"));
var _server = require("react-dom/server");
var _rxjs = require("rxjs");
var _securityAuthorizationCore = require("@kbn/security-authorization-core");
var _api_authorization = require("./api_authorization");
var _app_authorization = require("./app_authorization");
var _check_privileges = require("./check_privileges");
var _check_privileges_dynamically = require("./check_privileges_dynamically");
var _check_saved_objects_privileges = require("./check_saved_objects_privileges");
var _disable_ui_capabilities = require("./disable_ui_capabilities");
var _mode = require("./mode");
var _register_privileges_with_cluster = require("./register_privileges_with_cluster");
var _reset_session_page = require("./reset_session_page");
var _validate_feature_privileges = require("./validate_feature_privileges");
var _validate_reserved_privileges = require("./validate_reserved_privileges");
var _constants = require("../../common/constants");
var _authentication = require("../authentication");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/security/server/authorization/authorization_service.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class AuthorizationService {
  constructor() {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "applicationName", void 0);
    (0, _defineProperty2.default)(this, "privileges", void 0);
    (0, _defineProperty2.default)(this, "statusSubscription", void 0);
  }
  setup({
    http,
    capabilities,
    packageVersion,
    getClusterClient,
    license,
    loggers,
    features,
    kibanaIndexName,
    getSpacesService,
    getCurrentUser,
    customBranding
  }) {
    this.logger = loggers.get('authorization');
    this.applicationName = `${_constants.APPLICATION_PREFIX}${kibanaIndexName}`;
    const mode = (0, _mode.authorizationModeFactory)(license);
    const actions = new _securityAuthorizationCore.Actions();
    this.privileges = (0, _securityAuthorizationCore.privilegesFactory)(actions, features, license);
    const {
      checkPrivilegesWithRequest,
      checkUserProfilesPrivileges
    } = (0, _check_privileges.checkPrivilegesFactory)(actions, getClusterClient, this.applicationName);
    const esSecurityConfig = getClusterClient().then(client => client.asInternalUser.xpack.usage({
      filter_path: 'security.operator_privileges'
    })).then(({
      security
    }) => security);
    const authz = {
      actions,
      applicationName: this.applicationName,
      mode,
      privileges: this.privileges,
      checkPrivilegesWithRequest,
      checkUserProfilesPrivileges,
      checkPrivilegesDynamicallyWithRequest: (0, _check_privileges_dynamically.checkPrivilegesDynamicallyWithRequestFactory)(checkPrivilegesWithRequest, getSpacesService),
      checkSavedObjectsPrivilegesWithRequest: (0, _check_saved_objects_privileges.checkSavedObjectsPrivilegesWithRequestFactory)(checkPrivilegesWithRequest, getSpacesService)
    };
    capabilities.registerSwitcher(async (request, uiCapabilities) => {
      // If we have a license which doesn't enable security, or we're a legacy user we shouldn't
      // disable any ui capabilities
      if (!mode.useRbacForRequest(request)) {
        return {};
      }
      const disableUICapabilities = (0, _disable_ui_capabilities.disableUICapabilitiesFactory)(request, features.getKibanaFeatures(), features.getElasticsearchFeatures(), this.logger, authz, getCurrentUser(request));
      if (!request.auth.isAuthenticated) {
        return disableUICapabilities.all(uiCapabilities);
      }
      return await disableUICapabilities.usingPrivileges(uiCapabilities);
    }, {
      capabilityPath: '*'
    });
    (0, _api_authorization.initAPIAuthorization)(http, {
      ...authz,
      getCurrentUser,
      getSecurityConfig: () => esSecurityConfig
    }, loggers.get('api-authorization'));
    (0, _app_authorization.initAppAuthorization)(http, authz, loggers.get('app-authorization'), features);
    http.registerOnPreResponse(async (request, preResponse, toolkit) => {
      if (preResponse.statusCode === 403) {
        const user = getCurrentUser(request);
        if ((user === null || user === void 0 ? void 0 : user.roles.length) === 0) {
          this.logger.warn(`A user authenticated with the "${user.authentication_realm.name}" (${user.authentication_realm.type}) realm doesn't have any roles and isn't authorized to perform request.`);
        }
        if ((0, _authentication.canRedirectRequest)(request)) {
          const customBrandingValue = await customBranding.getBrandingFor(request, {
            unauthenticated: false
          });
          const next = `${http.basePath.get(request)}${request.url.pathname}${request.url.search}`;
          const body = (0, _server.renderToString)(/*#__PURE__*/_react.default.createElement(_reset_session_page.ResetSessionPage, {
            staticAssets: http.staticAssets,
            basePath: http.basePath,
            logoutUrl: http.basePath.prepend(`/api/security/logout?${_querystring.default.stringify({
              next
            })}`),
            customBranding: customBrandingValue,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 201,
              columnNumber: 13
            }
          }));
          return toolkit.render({
            body,
            headers: {
              'Content-Security-Policy': http.csp.header,
              'Content-Security-Policy-Report-Only': http.csp.reportOnlyHeader
            }
          });
        }
      }
      return toolkit.next();
    });
    return authz;
  }
  start({
    clusterClient,
    features,
    online$
  }) {
    const allFeatures = features.getKibanaFeatures();
    (0, _validate_feature_privileges.validateFeaturePrivileges)(allFeatures);
    (0, _validate_reserved_privileges.validateReservedPrivileges)(allFeatures);
    this.statusSubscription = online$.pipe((0, _rxjs.switchMap)(async ({
      scheduleRetry
    }) => {
      try {
        await (0, _register_privileges_with_cluster.registerPrivilegesWithCluster)(this.logger, this.privileges, this.applicationName, clusterClient);
      } catch (err) {
        scheduleRetry();
      }
    })).subscribe();
  }
  stop() {
    if (this.statusSubscription !== undefined) {
      this.statusSubscription.unsubscribe();
      this.statusSubscription = undefined;
    }
  }
}
exports.AuthorizationService = AuthorizationService;