"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateChangePasswordForm = exports.ChangePasswordModal = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _uiTheme = require("@kbn/ui-theme");
var _use_current_user = require("../../../components/use_current_user");
var _use_form = require("../../../components/use_form");
var _use_initial_focus = require("../../../components/use_initial_focus");
var _user_api_client = require("../user_api_client");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/security/public/management/users/edit_user/change_password_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const MIN_PASSWORD_LENGTH = 6;
const validateChangePasswordForm = (values, isCurrentUser) => {
  const errors = {};
  if (isCurrentUser) {
    if (!values.current_password) {
      errors.current_password = _i18n.i18n.translate('xpack.security.management.users.changePasswordForm.currentPasswordRequiredError', {
        defaultMessage: 'Enter your current password.'
      });
    }
  }
  if (!values.password) {
    errors.password = _i18n.i18n.translate('xpack.security.management.users.changePasswordForm.passwordRequiredError', {
      defaultMessage: 'Enter a new password.'
    });
  } else if (values.password.length < MIN_PASSWORD_LENGTH) {
    errors.password = _i18n.i18n.translate('xpack.security.management.users.changePasswordForm.passwordInvalidError', {
      defaultMessage: 'Enter at least {minLength} characters.',
      values: {
        minLength: MIN_PASSWORD_LENGTH
      }
    });
  } else if (values.password !== values.confirm_password) {
    errors.confirm_password = _i18n.i18n.translate('xpack.security.management.users.changePasswordForm.confirmPasswordInvalidError', {
      defaultMessage: 'Passwords do not match.'
    });
  }
  return errors;
};
exports.validateChangePasswordForm = validateChangePasswordForm;
const ChangePasswordModal = ({
  username,
  defaultValues = {
    current_password: '',
    password: '',
    confirm_password: ''
  },
  onSuccess,
  onCancel
}) => {
  const {
    services
  } = (0, _public.useKibana)();
  const {
    value: currentUser,
    loading: isLoading
  } = (0, _use_current_user.useCurrentUser)();
  const isCurrentUser = (currentUser === null || currentUser === void 0 ? void 0 : currentUser.username) === username;
  const isSystemUser = username === 'kibana' || username === 'kibana_system';
  const [form, {
    onBlur,
    ...eventHandlers
  }] = (0, _use_form.useForm)({
    onSubmit: async values => {
      try {
        await new _user_api_client.UserAPIClient(services.http).changePassword(username, values.password, values.current_password);
        services.notifications.toasts.addSuccess(_i18n.i18n.translate('xpack.security.management.users.changePasswordForm.successMessage', {
          defaultMessage: 'Password successfully changed'
        }));
        onSuccess === null || onSuccess === void 0 ? void 0 : onSuccess();
      } catch (error) {
        var _body;
        if (((_body = error.body) === null || _body === void 0 ? void 0 : _body.statusCode) === 403) {
          form.setError('current_password', _i18n.i18n.translate('xpack.security.management.users.changePasswordForm.currentPasswordInvalidError', {
            defaultMessage: 'Invalid password.'
          }));
        } else {
          var _body2;
          services.notifications.toasts.addDanger({
            title: _i18n.i18n.translate('xpack.security.management.users.changePasswordForm.errorMessage', {
              defaultMessage: 'Could not change password'
            }),
            text: ((_body2 = error.body) === null || _body2 === void 0 ? void 0 : _body2.message) || error.message
          });
          throw error;
        }
      }
    },
    validate: async values => validateChangePasswordForm(values, isCurrentUser),
    defaultValues
  });

  // For some reason, the focus-lock dependency that EuiModal uses to accessibly trap focus
  // is fighting the form `onBlur` and causing focus to be lost when clicking between password
  // fields, so this workaround waits a tick before validating the form on blur
  const validateFormOnBlur = event => {
    requestAnimationFrame(() => onBlur(event));
  };
  const firstFieldRef = (0, _use_initial_focus.useInitialFocus)([isLoading]);
  const modalFormId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'modalForm'
  });
  const modalTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'changePasswordModalTitle'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: onCancel,
    "aria-labelledby": modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: modalTitleId,
    "data-test-subj": "confirmModalTitleText",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.management.users.changePasswordForm.title",
    defaultMessage: "Change password",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    isLoading: isLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, (0, _extends2.default)({
    id: modalFormId,
    component: "form",
    noValidate: true
  }, eventHandlers, {
    onBlur: validateFormOnBlur,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 11
    }
  }), isSystemUser ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    title: _i18n.i18n.translate('xpack.security.management.users.changePasswordForm.systemUserTitle', {
      defaultMessage: 'Kibana will lose connection to Elasticsearch'
    }),
    color: "danger",
    iconType: "warning",
    style: {
      maxWidth: _uiTheme.euiThemeVars.euiFormMaxWidth
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.management.users.changePasswordForm.systemUserWarning",
    defaultMessage: "After changing the password for the {username} user, Kibana will be unusable.",
    values: {
      username
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 21
    }
  })), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.management.users.changePasswordForm.systemUserDescription",
    defaultMessage: "To regain access, update your config file with the new password and restart Kibana.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 21
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 17
    }
  })) : undefined, isCurrentUser ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.security.management.users.changePasswordForm.currentPasswordLabel', {
      defaultMessage: 'Current password'
    }),
    error: form.errors.current_password,
    isInvalid: form.touched.current_password && !!form.errors.current_password,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldPassword, {
    name: "current_password",
    type: "dual",
    defaultValue: form.values.current_password,
    isInvalid: form.touched.current_password && !!form.errors.current_password,
    autoComplete: "current-password",
    inputRef: firstFieldRef,
    "data-test-subj": "editUserChangePasswordCurrentPasswordInput",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 19
    }
  }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.security.management.users.changePasswordForm.userLabel', {
      defaultMessage: 'User'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 239,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "user",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 21
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 242,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 243,
      columnNumber: 21
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 244,
      columnNumber: 21
    }
  }, username), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 245,
      columnNumber: 21
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.security.management.users.changePasswordForm.passwordLabel', {
      defaultMessage: 'New password'
    }),
    helpText: _i18n.i18n.translate('xpack.security.management.users.changePasswordForm.passwordHelpText', {
      defaultMessage: 'Password must be at least {minLength} characters.',
      values: {
        minLength: MIN_PASSWORD_LENGTH
      }
    }),
    error: form.errors.password,
    isInvalid: form.touched.password && !!form.errors.password,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldPassword, {
    name: "password",
    type: "dual",
    defaultValue: form.values.password,
    isInvalid: form.touched.password && !!form.errors.password,
    autoComplete: "new-password",
    inputRef: isCurrentUser ? undefined : firstFieldRef,
    "data-test-subj": "editUserChangePasswordNewPasswordInput",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 266,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.security.management.users.changePasswordForm.confirmPasswordLabel', {
      defaultMessage: 'Confirm password'
    }),
    error: form.errors.confirm_password,
    isInvalid: form.touched.confirm_password && !!form.errors.confirm_password,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 276,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldPassword, {
    name: "confirm_password",
    type: "dual",
    defaultValue: form.values.confirm_password,
    isInvalid: form.touched.confirm_password && !!form.errors.confirm_password,
    autoComplete: "new-password",
    "data-test-subj": "editUserChangePasswordConfirmPasswordInput",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 284,
      columnNumber: 15
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 296,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "changePasswordFormCancelButton",
    "aria-label": _i18n.i18n.translate('xpack.security.management.users.changePasswordForm.cancelButtonLabel', {
      defaultMessage: 'Cancel password change'
    }),
    isDisabled: form.isSubmitting,
    onClick: onCancel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 297,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.changePasswordForm.cancelButton",
    defaultMessage: "Cancel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 308,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "lock",
    type: "submit",
    form: modalFormId,
    "data-test-subj": "changePasswordFormSubmitButton",
    isLoading: form.isSubmitting,
    isDisabled: isLoading || form.isInvalid || !form.values.password || !form.values.confirm_password || isCurrentUser && !form.values.current_password,
    color: isSystemUser ? 'danger' : undefined,
    fill: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 313,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.changePasswordForm.confirmButton",
    defaultMessage: "{isSubmitting, select, true{Changing password\u2026} other{Change password}}",
    values: {
      isSubmitting: form.isSubmitting
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 329,
      columnNumber: 11
    }
  }))));
};
exports.ChangePasswordModal = ChangePasswordModal;