"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElasticsearchPrivileges = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _cluster_privileges = require("./cluster_privileges");
var _index_privileges = require("./index_privileges");
var _remote_cluster_privileges = require("./remote_cluster_privileges");
var _collapsible_panel = require("../../collapsible_panel");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/security/public/management/roles/edit_role/privileges/es/elasticsearch_privileges.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class ElasticsearchPrivileges extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "getForm", () => {
      var _builtinESPrivileges$;
      const {
        role,
        indicesAPIClient,
        docLinks,
        validator,
        onChange,
        editable,
        indexPatterns,
        remoteClusters,
        license,
        builtinESPrivileges,
        canUseRemoteIndices,
        canUseRemoteClusters,
        buildFlavor
      } = this.props;
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 79,
          columnNumber: 7
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
        title: /*#__PURE__*/_react.default.createElement("h3", {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 82,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRole.elasticSearchPrivileges.clusterPrivilegesTitle",
          defaultMessage: "Cluster privileges",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 83,
            columnNumber: 15
          }
        })),
        description: /*#__PURE__*/_react.default.createElement("p", {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 90,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRole.elasticSearchPrivileges.manageRoleActionsDescription",
          defaultMessage: "Manage the actions this role can perform against your cluster. ",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 91,
            columnNumber: 15
          }
        }), this.learnMore(docLinks.links.security.clusterPrivileges)),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 80,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        fullWidth: true,
        hasEmptyLabelSpace: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 99,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_cluster_privileges.ClusterPrivileges, {
        role: this.props.role,
        onChange: this.onClusterPrivilegesChange,
        builtinClusterPrivileges: builtinESPrivileges.cluster,
        editable: editable,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 100,
          columnNumber: 13
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 108,
          columnNumber: 9
        }
      }), buildFlavor === 'traditional' && canUseRemoteClusters && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "xs",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 111,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement("h3", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 112,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.editRole.elasticSearchPrivileges.remoteClusterPrivilegesTitle",
        defaultMessage: "Remote cluster privileges",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 113,
          columnNumber: 17
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 119,
          columnNumber: 13
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        color: "subdued",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 120,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 121,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.editRole.elasticSearchPrivileges.controlAccessToRemoteClusterActionsDescription",
        defaultMessage: "Manage the actions this role can perform against your remote cluster. ",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 122,
          columnNumber: 17
        }
      }), this.learnMore(docLinks.links.security.clusterPrivileges))), /*#__PURE__*/_react.default.createElement(_remote_cluster_privileges.RemoteClusterPrivileges, {
        remoteClusters: remoteClusters,
        role: role,
        validator: validator,
        license: license,
        onChange: onChange,
        availableRemoteClusterPrivileges: (_builtinESPrivileges$ = builtinESPrivileges.remote_cluster) !== null && _builtinESPrivileges$ !== void 0 ? _builtinESPrivileges$ : [],
        editable: editable,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 129,
          columnNumber: 13
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 138,
          columnNumber: 13
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 139,
          columnNumber: 13
        }
      })), buildFlavor === 'traditional' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
        title: /*#__PURE__*/_react.default.createElement("h3", {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 147,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRole.elasticSearchPrivileges.runAsPrivilegesTitle",
          defaultMessage: "Run As privileges",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 148,
            columnNumber: 19
          }
        })),
        description: /*#__PURE__*/_react.default.createElement("p", {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 155,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRole.elasticSearchPrivileges.howToBeSubmittedOnBehalfOfOtherUsersDescription",
          defaultMessage: "Allow requests to be submitted on the behalf of other users. ",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 156,
            columnNumber: 19
          }
        }), this.learnMore(docLinks.links.security.runAsPrivilege)),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 145,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
        "aria-label": _i18n.i18n.translate('xpack.security.management.editRole.elasticSearchPrivileges.runAsPrivilegesAriaLabel', {
          defaultMessage: 'Run as privileges'
        }),
        placeholder: this.props.editable ? _i18n.i18n.translate('xpack.security.management.editRole.elasticSearchPrivileges.addUserTitle', {
          defaultMessage: 'Add a user…'
        }) : undefined,
        options: this.props.runAsUsers.map(username => ({
          label: username,
          isGroupLabelOption: false
        })),
        selectedOptions: this.props.role.elasticsearch.run_as.map(u => ({
          label: u
        })),
        onCreateOption: this.onCreateRunAsOption,
        onChange: this.onRunAsUserChange,
        isDisabled: !editable,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 164,
          columnNumber: 15
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 187,
          columnNumber: 13
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "xs",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 191,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement("h3", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 192,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.editRole.elasticSearchPrivileges.indexPrivilegesTitle",
        defaultMessage: "Index privileges",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 193,
          columnNumber: 13
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 199,
          columnNumber: 9
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        color: "subdued",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 200,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 201,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.editRole.elasticSearchPrivileges.controlAccessToClusterDataDescription",
        defaultMessage: "Control access to the data in your cluster. ",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 202,
          columnNumber: 13
        }
      }), this.learnMore(docLinks.links.security.indicesPrivileges))), /*#__PURE__*/_react.default.createElement(_index_privileges.IndexPrivileges, {
        indexType: "indices",
        indexPatterns: indexPatterns,
        role: role,
        indicesAPIClient: indicesAPIClient,
        validator: validator,
        license: license,
        onChange: onChange,
        availableIndexPrivileges: builtinESPrivileges.index,
        editable: editable,
        isDarkMode: this.props.isDarkMode,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 209,
          columnNumber: 9
        }
      }), buildFlavor === 'traditional' && canUseRemoteIndices && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 223,
          columnNumber: 13
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 224,
          columnNumber: 13
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "xs",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 226,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement("h3", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 227,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.editRole.elasticSearchPrivileges.remoteIndexPrivilegesTitle",
        defaultMessage: "Remote index privileges",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 228,
          columnNumber: 17
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 234,
          columnNumber: 13
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        color: "subdued",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 235,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 236,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.editRole.elasticSearchPrivileges.controlAccessToRemoteClusterDataDescription",
        defaultMessage: "Control access to the data in remote clusters. ",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 237,
          columnNumber: 17
        }
      }), this.learnMore(docLinks.links.security.indicesPrivileges))), /*#__PURE__*/_react.default.createElement(_index_privileges.IndexPrivileges, {
        indexType: "remote_indices",
        remoteClusters: remoteClusters,
        role: role,
        indicesAPIClient: indicesAPIClient,
        validator: validator,
        license: license,
        onChange: onChange,
        availableIndexPrivileges: builtinESPrivileges.index,
        editable: editable,
        isDarkMode: this.props.isDarkMode,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 244,
          columnNumber: 13
        }
      })));
    });
    (0, _defineProperty2.default)(this, "learnMore", href => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      className: "editRole__learnMore",
      href: href,
      target: '_blank',
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 263,
        columnNumber: 5
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.editRole.elasticSearchPrivileges.learnMoreLinkText",
      defaultMessage: "Learn more",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 264,
        columnNumber: 7
      }
    })));
    (0, _defineProperty2.default)(this, "addIndexPrivilege", () => {
      const {
        role
      } = this.props;
      const newIndices = [...role.elasticsearch.indices, {
        names: [],
        privileges: [],
        field_security: {
          grant: ['*']
        }
      }];
      this.props.onChange({
        ...this.props.role,
        elasticsearch: {
          ...this.props.role.elasticsearch,
          indices: newIndices
        }
      });
    });
    (0, _defineProperty2.default)(this, "onClusterPrivilegesChange", cluster => {
      const role = {
        ...this.props.role,
        elasticsearch: {
          ...this.props.role.elasticsearch,
          cluster
        }
      };
      this.props.onChange(role);
    });
    (0, _defineProperty2.default)(this, "onRunAsUserChange", users => {
      const role = {
        ...this.props.role,
        elasticsearch: {
          ...this.props.role.elasticsearch,
          run_as: users.map(u => u.label)
        }
      };
      this.props.onChange(role);
    });
    (0, _defineProperty2.default)(this, "onCreateRunAsOption", option => {
      const newRunAsUsers = this.props.role.elasticsearch.run_as.concat(option);
      const role = {
        ...this.props.role,
        elasticsearch: {
          ...this.props.role.elasticsearch,
          run_as: newRunAsUsers
        }
      };
      this.props.onChange(role);
    });
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_collapsible_panel.CollapsiblePanel, {
      iconType: 'logoElasticsearch',
      title: 'Elasticsearch',
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 7
      }
    }, this.getForm());
  }
}
exports.ElasticsearchPrivileges = ElasticsearchPrivileges;