"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RoleTableDisplay = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _model = require("../../../common/model");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/security/public/management/role_table_display/role_table_display.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const RoleTableDisplay = ({
  role,
  navigateToApp
}) => {
  let content;
  let path;
  if (typeof role === 'string') {
    content = /*#__PURE__*/_react.default.createElement("div", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 25,
        columnNumber: 15
      }
    }, role);
    path = `security/roles/edit/${encodeURIComponent(role)}`;
  } else if ((0, _model.isRoleDeprecated)(role)) {
    content = /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: (0, _model.getExtendedRoleDeprecationNotice)(role),
      "data-test-subj": "roleDeprecationTooltip",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 29,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      tabIndex: 0,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 33,
        columnNumber: 9
      }
    }, role.name, " ", /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "warning",
      color: "warning",
      size: "s",
      className: 'eui-alignTop',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 34,
        columnNumber: 23
      }
    })));
    path = `security/roles/edit/${encodeURIComponent(role.name)}`;
  } else {
    content = /*#__PURE__*/_react.default.createElement("div", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 15
      }
    }, role.name);
    path = `security/roles/edit/${encodeURIComponent(role.name)}`;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: () => navigateToApp('management', {
      path
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 10
    }
  }, content);
};
exports.RoleTableDisplay = RoleTableDisplay;