"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldRuleEditor = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _model = require("../../model");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/security/public/management/role_mappings/edit_role_mapping/rule_editor_panel/field_rule_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const userFields = [{
  name: 'username'
}, {
  name: 'dn'
}, {
  name: 'groups'
}, {
  name: 'realm.name'
}];
const fieldOptions = userFields.map(f => ({
  label: f.name
}));
const comparisonOptions = {
  text: {
    id: 'text',
    defaultValue: '*'
  },
  number: {
    id: 'number',
    defaultValue: 0
  },
  null: {
    id: 'null',
    defaultValue: null
  },
  boolean: {
    id: 'boolean',
    defaultValue: true
  }
};
class FieldRuleEditor extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "renderFieldRow", (field, ruleValue, valueIndex) => {
      const isPrimaryRow = valueIndex === 0;
      let renderAddValueButton = true;
      let rowRuleValue = ruleValue;
      if (Array.isArray(ruleValue)) {
        renderAddValueButton = ruleValue.length - 1 === valueIndex;
        rowRuleValue = ruleValue[valueIndex];
      }
      const comparisonType = this.getComparisonType(rowRuleValue);
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 109,
          columnNumber: 7
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: 1,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 110,
          columnNumber: 9
        }
      }, isPrimaryRow ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        label: _i18n.i18n.translate('xpack.security.management.editRoleMapping.fieldRuleEditor.userFieldLabel', {
          defaultMessage: 'User field'
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 112,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
        isClearable: false,
        selectedOptions: [{
          label: field
        }],
        singleSelection: {
          asPlainText: true
        },
        onChange: this.onFieldChange,
        onCreateOption: this.onAddField,
        options: fieldOptions,
        "data-test-subj": `fieldRuleEditorField-${valueIndex} fieldRuleEditorField-${valueIndex}-combo`,
        isDisabled: this.props.readOnly,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 118,
          columnNumber: 15
        }
      })) : /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        hasEmptyLabelSpace: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 130,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
        description: _i18n.i18n.translate('xpack.security.management.editRoleMapping.fieldRuleEditor.orLabel', {
          defaultMessage: 'or'
        }),
        value: field,
        "data-test-subj": `fieldRuleEditorField-${valueIndex} fieldRuleEditorField-${valueIndex}-expression`,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 131,
          columnNumber: 15
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 142,
          columnNumber: 9
        }
      }, this.renderFieldTypeInput(comparisonType.id, valueIndex)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: 1,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 145,
          columnNumber: 9
        }
      }, this.renderFieldValueInput(comparisonType.id, rowRuleValue, valueIndex)), this.conditionallyRenderAddButton(renderAddValueButton), this.conditionallyRenderDeleteButton(valueIndex));
    });
    (0, _defineProperty2.default)(this, "conditionallyRenderAddButton", renderAddValueButton => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 156,
          columnNumber: 7
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        hasEmptyLabelSpace: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 157,
          columnNumber: 9
        }
      }, this.props.readOnly === false && renderAddValueButton ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        iconSize: "s",
        iconType: "plusInCircle",
        onClick: this.onAddAlternateValue,
        color: "primary",
        "data-test-subj": "addAlternateValueButton",
        "aria-label": _i18n.i18n.translate('xpack.security.management.editRoleMapping.fieldRuleEditor.addAlternateValueButton', {
          defaultMessage: 'Add alternate value'
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 159,
          columnNumber: 13
        }
      }) : /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        size: "s",
        type: "empty",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 173,
          columnNumber: 13
        }
      })));
    });
    (0, _defineProperty2.default)(this, "conditionallyRenderDeleteButton", valueIndex => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: 1,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 182,
          columnNumber: 7
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        hasEmptyLabelSpace: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 183,
          columnNumber: 9
        }
      }, this.props.readOnly === false ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        iconType: "trash",
        color: "danger",
        iconSize: "s",
        "data-test-subj": `fieldRuleEditorDeleteValue fieldRuleEditorDeleteValue-${valueIndex}`,
        "aria-label": _i18n.i18n.translate('xpack.security.management.editRoleMapping.fieldRuleEditor.deleteValueLabel', {
          defaultMessage: 'Delete value'
        }),
        onClick: () => this.onRemoveAlternateValue(valueIndex),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 185,
          columnNumber: 13
        }
      }) : /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        size: "s",
        type: "empty",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 199,
          columnNumber: 13
        }
      })));
    });
    (0, _defineProperty2.default)(this, "renderFieldTypeInput", (inputType, valueIndex) => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        label: _i18n.i18n.translate('xpack.security.management.editRoleMapping.fieldRuleEditor.typeFormRow', {
          defaultMessage: 'Type'
        }),
        key: valueIndex,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 208,
          columnNumber: 7
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
        options: [{
          value: 'text',
          text: 'text'
        }, {
          value: 'number',
          text: 'number'
        }, {
          value: 'null',
          text: 'is null'
        }, {
          value: 'boolean',
          text: 'boolean'
        }],
        "data-test-subj": `fieldRuleEditorValueType-${valueIndex}`,
        value: inputType,
        onChange: e => this.onComparisonTypeChange(valueIndex, e.target.value),
        disabled: this.props.readOnly,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 217,
          columnNumber: 9
        }
      }));
    });
    (0, _defineProperty2.default)(this, "renderFieldValueInput", (fieldType, rowRuleValue, valueIndex) => {
      const inputField = this.getInputFieldForType(fieldType, rowRuleValue, valueIndex);
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        label: _i18n.i18n.translate('xpack.security.management.editRoleMapping.fieldRuleEditor.valueFormRow', {
          defaultMessage: 'Value'
        }),
        key: valueIndex,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 243,
          columnNumber: 7
        }
      }, inputField);
    });
    (0, _defineProperty2.default)(this, "getInputFieldForType", (fieldType, rowRuleValue, valueIndex) => {
      const isNullValue = rowRuleValue === null;
      const commonProps = {
        'data-test-subj': `fieldRuleEditorValue-${valueIndex}`
      };
      switch (fieldType) {
        case 'boolean':
          return /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, (0, _extends2.default)({}, commonProps, {
            value: rowRuleValue === null || rowRuleValue === void 0 ? void 0 : rowRuleValue.toString(),
            onChange: this.onBooleanValueChange(valueIndex),
            options: [{
              value: 'true',
              text: 'true'
            }, {
              value: 'false',
              text: 'false'
            }],
            disabled: this.props.readOnly,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 271,
              columnNumber: 11
            }
          }));
        case 'text':
        case 'null':
          return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({}, commonProps, {
            value: isNullValue ? '-- null --' : rowRuleValue,
            onChange: this.onValueChange(valueIndex),
            disabled: isNullValue || this.props.readOnly,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 285,
              columnNumber: 11
            }
          }));
        case 'number':
          return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
            "data-test-subj": `fieldRuleEditorValue-${valueIndex}`,
            value: rowRuleValue,
            onChange: this.onNumericValueChange(valueIndex),
            disabled: this.props.readOnly,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 294,
              columnNumber: 11
            }
          });
        default:
          throw new Error(`Unsupported input field type: ${fieldType}`);
      }
    });
    (0, _defineProperty2.default)(this, "onAddAlternateValue", () => {
      const {
        field,
        value
      } = this.props.rule;
      const nextValue = Array.isArray(value) ? [...value] : [value];
      nextValue.push('*');
      this.props.onChange(new _model.FieldRule(field, nextValue));
    });
    (0, _defineProperty2.default)(this, "onRemoveAlternateValue", index => {
      const {
        field,
        value
      } = this.props.rule;
      if (!Array.isArray(value) || value.length === 1) {
        // Only one value left. Delete entire rule instead.
        this.props.onDelete();
        return;
      }
      const nextValue = [...value];
      nextValue.splice(index, 1);
      this.props.onChange(new _model.FieldRule(field, nextValue));
    });
    (0, _defineProperty2.default)(this, "onFieldChange", ([newField]) => {
      if (!newField) {
        return;
      }
      const {
        value
      } = this.props.rule;
      this.props.onChange(new _model.FieldRule(newField.label, value));
    });
    (0, _defineProperty2.default)(this, "onAddField", newField => {
      const {
        value
      } = this.props.rule;
      this.props.onChange(new _model.FieldRule(newField, value));
    });
    (0, _defineProperty2.default)(this, "onValueChange", index => e => {
      const {
        field,
        value
      } = this.props.rule;
      let nextValue;
      if (Array.isArray(value)) {
        nextValue = [...value];
        nextValue.splice(index, 1, e.target.value);
      } else {
        nextValue = e.target.value;
      }
      this.props.onChange(new _model.FieldRule(field, nextValue));
    });
    (0, _defineProperty2.default)(this, "onNumericValueChange", index => e => {
      const {
        field,
        value
      } = this.props.rule;
      let nextValue;
      if (Array.isArray(value)) {
        nextValue = [...value];
        nextValue.splice(index, 1, parseFloat(e.target.value));
      } else {
        nextValue = parseFloat(e.target.value);
      }
      this.props.onChange(new _model.FieldRule(field, nextValue));
    });
    (0, _defineProperty2.default)(this, "onBooleanValueChange", index => e => {
      const boolValue = e.target.value === 'true';
      const {
        field,
        value
      } = this.props.rule;
      let nextValue;
      if (Array.isArray(value)) {
        nextValue = [...value];
        nextValue.splice(index, 1, boolValue);
      } else {
        nextValue = boolValue;
      }
      this.props.onChange(new _model.FieldRule(field, nextValue));
    });
    (0, _defineProperty2.default)(this, "onComparisonTypeChange", (index, newType) => {
      const comparison = comparisonOptions[newType];
      if (!comparison) {
        throw new Error(`Unexpected comparison type: ${newType}`);
      }
      const {
        field,
        value
      } = this.props.rule;
      let nextValue = value;
      if (Array.isArray(value)) {
        nextValue = [...value];
        nextValue.splice(index, 1, comparison.defaultValue);
      } else {
        nextValue = comparison.defaultValue;
      }
      this.props.onChange(new _model.FieldRule(field, nextValue));
    });
  }
  render() {
    const {
      field,
      value
    } = this.props.rule;
    const content = Array.isArray(value) ? value.map((v, index) => this.renderFieldRow(field, value, index)) : [this.renderFieldRow(field, value, 0)];
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 7
      }
    }, content.map((row, index) => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        key: index,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 90,
          columnNumber: 18
        }
      }, row);
    }));
  }
  getComparisonType(ruleValue) {
    const valueType = typeof ruleValue;
    if (valueType === 'string' || valueType === 'undefined') {
      return comparisonOptions.text;
    }
    if (valueType === 'number') {
      return comparisonOptions.number;
    }
    if (valueType === 'boolean') {
      return comparisonOptions.boolean;
    }
    if (ruleValue === null) {
      return comparisonOptions.null;
    }
    throw new Error(`Unable to detect comparison type for rule value [${ruleValue}]`);
  }
}
exports.FieldRuleEditor = FieldRuleEditor;
(0, _defineProperty2.default)(FieldRuleEditor, "defaultProps", {
  readOnly: false
});